/***************************************************************************** 
 *  Copyright 2016, Siglent Technologies.  All Rights Reserved.  *
 *****************************************************************************/

/****************************************************************************
 *                       Siglent SSA3000X  Spectrum Analyzer                           
 *                                                                          
 * Title:    ssa3000x.h                                        
 * Purpose:  Siglent SSA3000X  Spectrum Analyzer                                       
 *           instrument driver declarations.                                
 *                                                                          
 ****************************************************************************/

#ifndef __SSA3000X_HEADER
#define __SSA3000X_HEADER

#include <ivi.h>
#include <ivispecan.h>  
    

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/****************************************************************************
 *----------------- Instrument Driver Revision Information -----------------*
 ****************************************************************************/

#define SSA3000X_MAJOR_VERSION                2     /* Instrument driver major version   */
#define SSA3000X_MINOR_VERSION                1     /* Instrument driver minor version   */

#define SSA3000X_CLASS_SPEC_MAJOR_VERSION     2     /* Class specification major version */
#define SSA3000X_CLASS_SPEC_MINOR_VERSION     0     /* Class specification minor version */        
                                                                    

#define SSA3000X_SUPPORTED_INSTRUMENT_MODELS  "SSA3000X"
#define SSA3000X_DRIVER_VENDOR                "Siglent Technologies"
#ifdef  _IVI_mswin64_
#define SSA3000X_DRIVER_DESCRIPTION           "Siglent SSA3000X  Spectrum Analyzer Instrument Driver [Compiled for 64-bit.]"
#else                    
#define SSA3000X_DRIVER_DESCRIPTION           "Siglent SSA3000X  Spectrum Analyzer Instrument Driver"
#endif
                    
 /**************************************************************************** 
 *------------------------------ Useful Macros -----------------------------* 
 ****************************************************************************/


/**************************************************************************** 
 *---------------------------- Attribute Defines ---------------------------* 
 ****************************************************************************/

    /*- IVI Inherent Instrument Attributes ---------------------------------*/    

        /* User Options */
#define SSA3000X_ATTR_RANGE_CHECK                                  IVI_ATTR_RANGE_CHECK                                   /* ViBoolean */
#define SSA3000X_ATTR_QUERY_INSTRUMENT_STATUS                      IVI_ATTR_QUERY_INSTRUMENT_STATUS                       /* ViBoolean */
#define SSA3000X_ATTR_CACHE                                        IVI_ATTR_CACHE                                         /* ViBoolean */
#define SSA3000X_ATTR_SIMULATE                                     IVI_ATTR_SIMULATE                                      /* ViBoolean */
#define SSA3000X_ATTR_RECORD_COERCIONS                             IVI_ATTR_RECORD_COERCIONS                              /* ViBoolean */
#define SSA3000X_ATTR_INTERCHANGE_CHECK                            IVI_ATTR_INTERCHANGE_CHECK                             /* ViBoolean */
        
        /* Driver Information  */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_PREFIX                       IVI_ATTR_SPECIFIC_DRIVER_PREFIX                        /* ViString, read-only  */
#define SSA3000X_ATTR_SUPPORTED_INSTRUMENT_MODELS                  IVI_ATTR_SUPPORTED_INSTRUMENT_MODELS                   /* ViString, read-only  */
#define SSA3000X_ATTR_GROUP_CAPABILITIES                           IVI_ATTR_GROUP_CAPABILITIES                            /* ViString, read-only  */
#define SSA3000X_ATTR_INSTRUMENT_MANUFACTURER                      IVI_ATTR_INSTRUMENT_MANUFACTURER                       /* ViString, read-only  */
#define SSA3000X_ATTR_INSTRUMENT_MODEL                             IVI_ATTR_INSTRUMENT_MODEL                              /* ViString, read-only  */
#define SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION                 IVI_ATTR_INSTRUMENT_FIRMWARE_REVISION                  /* ViString, read-only  */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_REVISION                     IVI_ATTR_SPECIFIC_DRIVER_REVISION                      /* ViString, read-only  */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_VENDOR                       IVI_ATTR_SPECIFIC_DRIVER_VENDOR                        /* ViString, read-only  */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_DESCRIPTION                  IVI_ATTR_SPECIFIC_DRIVER_DESCRIPTION                   /* ViString, read-only  */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION     IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION      /* ViInt32, read-only   */
#define SSA3000X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION     IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION      /* ViInt32, read-only   */

        /* Advanced Session Information */
#define SSA3000X_ATTR_LOGICAL_NAME                                 IVI_ATTR_LOGICAL_NAME                                  /* ViString, read-only  */
#define SSA3000X_ATTR_IO_RESOURCE_DESCRIPTOR                       IVI_ATTR_IO_RESOURCE_DESCRIPTOR                        /* ViString, read-only  */
#define SSA3000X_ATTR_DRIVER_SETUP                                 IVI_ATTR_DRIVER_SETUP                                  /* ViString, read-only  */

     /*- Instrument-Specific Attributes -------------------------------------*/ 
/*- IviSpecAn IviSpecAnBase Group Attributes ---------------*/
#define SSA3000X_ATTR_AMPLITUDE_UNITS                              IVISPECAN_ATTR_AMPLITUDE_UNITS                         /* ViInt32      */
#define SSA3000X_ATTR_ATTENUATION                                  IVISPECAN_ATTR_ATTENUATION                             /* ViReal64     */
#define SSA3000X_ATTR_ATTENUATION_AUTO                             IVISPECAN_ATTR_ATTENUATION_AUTO                        /* ViBoolean    */
#define SSA3000X_ATTR_DETECTOR_TYPE                                IVISPECAN_ATTR_DETECTOR_TYPE                           /* ViInt32      */
#define SSA3000X_ATTR_DETECTOR_TYPE_AUTO                           IVISPECAN_ATTR_DETECTOR_TYPE_AUTO                      /* ViBoolean    */
#define SSA3000X_ATTR_FREQUENCY_START                              IVISPECAN_ATTR_FREQUENCY_START                         /* ViReal64     */
#define SSA3000X_ATTR_FREQUENCY_STOP                               IVISPECAN_ATTR_FREQUENCY_STOP                          /* ViReal64     */
#define SSA3000X_ATTR_FREQUENCY_OFFSET                             IVISPECAN_ATTR_FREQUENCY_OFFSET                        /* ViReal64     */
#define SSA3000X_ATTR_INPUT_IMPEDANCE                              IVISPECAN_ATTR_INPUT_IMPEDANCE                         /* ViInt32      */
#define SSA3000X_ATTR_NUMBER_OF_SWEEPS                             IVISPECAN_ATTR_NUMBER_OF_SWEEPS                        /* ViInt32      */
#define SSA3000X_ATTR_REFERENCE_LEVEL                              IVISPECAN_ATTR_REFERENCE_LEVEL                         /* ViReal64     */
#define SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET                       IVISPECAN_ATTR_REFERENCE_LEVEL_OFFSET                  /* ViReal64     */
#define SSA3000X_ATTR_RESOLUTION_BANDWIDTH                         IVISPECAN_ATTR_RESOLUTION_BANDWIDTH                    /* ViReal64     */
#define SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO                    IVISPECAN_ATTR_RESOLUTION_BANDWIDTH_AUTO               /* ViBoolean    */
#define SSA3000X_ATTR_SWEEP_MODE_CONTINUOUS                        IVISPECAN_ATTR_SWEEP_MODE_CONTINUOUS                   /* ViBoolean    */
#define SSA3000X_ATTR_SWEEP_TIME                                   IVISPECAN_ATTR_SWEEP_TIME                              /* ViReal64     */
#define SSA3000X_ATTR_SWEEP_TIME_AUTO                              IVISPECAN_ATTR_SWEEP_TIME_AUTO                         /* ViBoolean    */
#define SSA3000X_ATTR_TRACE_COUNT                                  IVISPECAN_ATTR_TRACE_COUNT                             /* ViInt32      */
#define SSA3000X_ATTR_TRACE_SIZE                                   IVISPECAN_ATTR_TRACE_SIZE                              /* ViInt32      */
#define SSA3000X_ATTR_TRACE_TYPE                                   IVISPECAN_ATTR_TRACE_TYPE                              /* ViInt32      */
#define SSA3000X_ATTR_VERTICAL_SCALE                               IVISPECAN_ATTR_VERTICAL_SCALE                          /* ViInt32      */
#define SSA3000X_ATTR_VIDEO_BANDWIDTH                              IVISPECAN_ATTR_VIDEO_BANDWIDTH                         /* ViReal64     */
#define SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO                         IVISPECAN_ATTR_VIDEO_BANDWIDTH_AUTO                    /* ViBoolean    */

 /*- IviSpecAn IviSpecAnMarker Group Attributes ---------------*/
#define SSA3000X_ATTR_ACTIVE_MARKER                                IVISPECAN_ATTR_ACTIVE_MARKER                           /* ViString     */
#define SSA3000X_ATTR_MARKER_AMPLITUDE                             IVISPECAN_ATTR_MARKER_AMPLITUDE                        /* ViReal64     */
#define SSA3000X_ATTR_MARKER_COUNT                                 IVISPECAN_ATTR_MARKER_COUNT                            /* ViInt32      */
#define SSA3000X_ATTR_MARKER_ENABLED                               IVISPECAN_ATTR_MARKER_ENABLED                          /* ViBoolean    */
#define SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED             IVISPECAN_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED        /* ViBoolean    */
#define SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_RESOLUTION          IVISPECAN_ATTR_MARKER_FREQUENCY_COUNTER_RESOLUTION     /* ViReal64     */
#define SSA3000X_ATTR_MARKER_POSITION                              IVISPECAN_ATTR_MARKER_POSITION                         /* ViReal64     */
#define SSA3000X_ATTR_MARKER_THRESHOLD                             IVISPECAN_ATTR_MARKER_THRESHOLD                        /* ViReal64     */
#define SSA3000X_ATTR_MARKER_TRACE                                 IVISPECAN_ATTR_MARKER_TRACE                            /* ViString     */
#define SSA3000X_ATTR_PEAK_EXCURSION                               IVISPECAN_ATTR_PEAK_EXCURSION                          /* ViReal64     */
#define SSA3000X_ATTR_SIGNAL_TRACK_ENABLED                         IVISPECAN_ATTR_SIGNAL_TRACK_ENABLED                    /* ViBoolean    */

 /*- IviSpecAn IviSpecAnTrigger Group Attributes ---------------*/
#define SSA3000X_ATTR_TRIGGER_SOURCE                               IVISPECAN_ATTR_TRIGGER_SOURCE                          /* ViInt32      */

 /*- IviSpecAn IviSpecAnExternalTrigger Group Attributes ---------------*/
#define SSA3000X_ATTR_EXTERNAL_TRIGGER_LEVEL                       IVISPECAN_ATTR_EXTERNAL_TRIGGER_LEVEL                  /* ViReal64     */
#define SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE                       IVISPECAN_ATTR_EXTERNAL_TRIGGER_SLOPE                  /* ViInt32      */

 /*- IviSpecAn IviSpecAnVideoTrigger Group Attributes ---------------*/
#define SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL                          IVISPECAN_ATTR_VIDEO_TRIGGER_LEVEL                     /* ViReal64     */
#define SSA3000X_ATTR_VIDEO_TRIGGER_SLOPE                          IVISPECAN_ATTR_VIDEO_TRIGGER_SLOPE                     /* ViInt32      */

 /*- IviSpecAn IviSpecAnDisplay Group Attributes ---------------*/
#define SSA3000X_ATTR_NUMBER_OF_DIVISIONS                          IVISPECAN_ATTR_NUMBER_OF_DIVISIONS                     /* ViInt32      */
#define SSA3000X_ATTR_UNITS_PER_DIVISION                           IVISPECAN_ATTR_UNITS_PER_DIVISION                      /* ViReal64     */

 /*- IviSpecAn IviSpecAnMarkerType Group Attributes ---------------*/
#define SSA3000X_ATTR_MARKER_TYPE                                  IVISPECAN_ATTR_MARKER_TYPE                             /* ViInt32      */

/*- ssa3000x-Specific Attributes -------------------------------------*/


#define SSA3000X_ATTR_ID_QUERY_RESPONSE                            (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1L)                    /* ViString (Read Only) */
 /*- IviSpecAnBase Group Attributes ---------------*/
#define SSA3000X_ATTR_ACTIVE_TRACE                                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1001L)                 /* ViString     */
#define SSA3000X_ATTR_TRACE_MATH_TYPE                              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1002L)                 /* ViInt32      */
#define SSA3000X_ATTR_VBW_RBW_RATIO_AUTO                           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1004L)                 /* ViBoolean    */
#define SSA3000X_ATTR_VBW_RBW_RATIO                                (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1005L)                 /* ViReal64     */
#define SSA3000X_ATTR_AVERAGE_DURATION_ENABLE                      (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1006L)                 /* ViBoolean    */
#define SSA3000X_ATTR_AVERAGE_DURATION                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1007L)                 /* ViReal64     */
#define SSA3000X_ATTR_AVERAGE_TYPE                                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1008L)                 /* ViInt32      */
#define SSA3000X_ATTR_AVERAGE_ENABLE                               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1009L)                 /* ViBoolean    */
#define SSA3000X_ATTR_AVERAGE_COUNT                                (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1010L)                 /* ViInt32      */
#define SSA3000X_ATTR_MEASUREMENT_TYPE                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1011L)                 /* ViInt32      */
#define SSA3000X_ATTR_INSTRUMENT_MODE                              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1012L)                 /* ViInt32      */
#define SSA3000X_ATTR_CENTER_FREQUENCY                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1013L)                 /* ViReal64     */
#define SSA3000X_ATTR_FREQUENCY_SPAN                               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1014L)                 /* ViReal64     */
#define SSA3000X_ATTR_SWEEP_MODE                                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1015L)                 /* ViInt32      */
#define SSA3000X_ATTR_FREQUENCY_SPAN_MODE                          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 1016L)                 /* ViInt32      */

/*- Tracking Generator Group Attributes ---------------*/
#define SSA3000X_ATTR_TG_NORMAILIZE_REFERENCE_POSITION             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2001L)                 /* ViReal64     */
#define SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2002L)                 /* ViReal64     */
#define SSA3000X_ATTR_TG_NORMALIZE_ENABLE                          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2003L)                 /* ViBoolean    */
#define SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2004L)                 /* ViReal64     */
#define SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2006L)                 /* ViBoolean    */
#define SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE                          (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 2007L)                 /* ViReal64     */

/*- OBW Group Attributes ---------------*/
#define SSA3000X_ATTR_OBW_POWER_LEVEL                              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 3001L)                 /* ViReal64     */
#define SSA3000X_ATTR_OBW_POWER_PERCENTAGE                         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 3002L)                 /* ViReal64     */
#define SSA3000X_ATTR_OBW_METHOD                                   (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 3003L)                 /* ViInt32      */

/*- CHP Group Attributes ---------------*/
#define SSA3000X_ATTR_CHP_CHANNEL_SPAN                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 4004L)                 /* ViReal64     */
#define SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH                    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 4005L)                 /* ViReal64     */
#define SSA3000X_ATTR_CHP_CENTER_FREQUENCY                         (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 4006L)                 /* ViReal64     */

/*- ACPR Group Attributes ---------------*/
#define SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH     (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 5001L)                 /* ViReal64     */
#define SSA3000X_ATTR_ACPR_CENTER_FREQUENCY                        (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 5002L)                 /* ViReal64     */

/*- IviSpecAnMarker Group Attributes ---------------*/
#define SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME               (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6001L)                 /* ViReal64     */
#define SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6002L)                 /* ViReal64     */
#define SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION                 (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6003L)                 /* ViInt32      */
#define SSA3000X_ATTR_MARKER_X_READOUT                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6004L)                 /* ViInt32      */
#define SSA3000X_ATTR_PEAK_SEARCH_TYPE                             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6006L)                 /* ViInt32      */
#define SSA3000X_ATTR_MARKER_FUNCTION                              (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6007L)                 /* ViInt32      */
#define SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING                    (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6008L)                 /* ViInt32      */
#define SSA3000X_ATTR_MARKER_PEAK_SEARCH                           (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6009L)                 /* ViInt32      */
#define SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE             (IVI_SPECIFIC_PUBLIC_ATTR_BASE + 6010L)                 /* ViBoolean    */

/*- IviSpecAnTrigger Group Attributes ---------------*/

/*- IviSpecAnDisplay Group Attributes ---------------*/

/*- Sweep Group Attributes ---------------*/


/****************************************************************************
 *------------------------ Attribute Value Defines -------------------------*
****************************************************************************/

/*- Defined values for attribute SSA3000X_ATTR_AMPLITUDE_UNITS -*/
#define SSA3000X_VAL_AMPLITUDE_UNITS_DBM                           IVISPECAN_VAL_AMPLITUDE_UNITS_DBM
#define SSA3000X_VAL_AMPLITUDE_UNITS_DBMV                          IVISPECAN_VAL_AMPLITUDE_UNITS_DBMV
#define SSA3000X_VAL_AMPLITUDE_UNITS_DBUV                          IVISPECAN_VAL_AMPLITUDE_UNITS_DBUV
#define SSA3000X_VAL_AMPLITUDE_UNITS_VOLT                          IVISPECAN_VAL_AMPLITUDE_UNITS_VOLT
#define SSA3000X_VAL_AMPLITUDE_UNITS_WATT                          IVISPECAN_VAL_AMPLITUDE_UNITS_WATT

/*- Defined values for attribute SSA3000X_ATTR_DETECTOR_TYPE -*/
#define SSA3000X_VAL_DETECTOR_TYPE_AVERAGE                         IVISPECAN_VAL_DETECTOR_TYPE_AVERAGE
#define SSA3000X_VAL_DETECTOR_TYPE_MAX_PEAK                        IVISPECAN_VAL_DETECTOR_TYPE_MAX_PEAK
#define SSA3000X_VAL_DETECTOR_TYPE_MIN_PEAK                        IVISPECAN_VAL_DETECTOR_TYPE_MIN_PEAK
#define SSA3000X_VAL_DETECTOR_TYPE_SAMPLE                          IVISPECAN_VAL_DETECTOR_TYPE_SAMPLE
#define SSA3000X_VAL_DETECTOR_TYPE_NORMAL                          IVISPECAN_VAL_DETECTOR_TYPE_RMS

/*- Defined values for attribute SSA3000X_ATTR_TRACE_TYPE -*/
#define SSA3000X_VAL_TRACE_TYPE_CLEAR_WRITE                        IVISPECAN_VAL_TRACE_TYPE_CLEAR_WRITE
#define SSA3000X_VAL_TRACE_TYPE_MAX_HOLD                           IVISPECAN_VAL_TRACE_TYPE_MAX_HOLD
#define SSA3000X_VAL_TRACE_TYPE_MIN_HOLD                           IVISPECAN_VAL_TRACE_TYPE_MIN_HOLD
#define SSA3000X_VAL_TRACE_TYPE_VIEW                               IVISPECAN_VAL_TRACE_TYPE_VIEW
#define SSA3000X_VAL_TRACE_TYPE_STORE                              IVISPECAN_VAL_TRACE_TYPE_STORE

/*- Defined values for attribute SSA3000X_ATTR_VERTICAL_SCALE -*/
#define SSA3000X_VAL_VERTICAL_SCALE_LINEAR                         IVISPECAN_VAL_VERTICAL_SCALE_LINEAR
#define SSA3000X_VAL_VERTICAL_SCALE_LOGARITHMIC                    IVISPECAN_VAL_VERTICAL_SCALE_LOGARITHMIC

/*- Defined values for attribute SSA3000X_ATTR_TRIGGER_SOURCE -*/
#define SSA3000X_VAL_TRIGGER_SOURCE_EXTERNAL                       IVISPECAN_VAL_TRIGGER_SOURCE_EXTERNAL
#define SSA3000X_VAL_TRIGGER_SOURCE_IMMEDIATE                      IVISPECAN_VAL_TRIGGER_SOURCE_IMMEDIATE
#define SSA3000X_VAL_TRIGGER_SOURCE_VIDEO                          IVISPECAN_VAL_TRIGGER_SOURCE_VIDEO

/*- Defined values for attribute SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE -*/
#define SSA3000X_VAL_EXTERNAL_TRIGGER_SLOPE_POSITIVE               IVISPECAN_VAL_EXTERNAL_TRIGGER_SLOPE_POSITIVE
#define SSA3000X_VAL_EXTERNAL_TRIGGER_SLOPE_NEGATIVE               IVISPECAN_VAL_EXTERNAL_TRIGGER_SLOPE_NEGATIVE

/*- Defined values for attribute SSA3000X_ATTR_VIDEO_TRIGGER_SLOPE -*/
#define SSA3000X_VAL_VIDEO_TRIGGER_SLOPE_POSITIVE                  IVISPECAN_VAL_VIDEO_TRIGGER_SLOPE_POSITIVE
#define SSA3000X_VAL_VIDEO_TRIGGER_SLOPE_NEGATIVE                  IVISPECAN_VAL_VIDEO_TRIGGER_SLOPE_NEGATIVE

/*- Defined values for attribute SSA3000X_ATTR_MARKER_TYPE -*/
#define SSA3000X_VAL_MARKER_TYPE_NORMAL                            IVISPECAN_VAL_MARKER_TYPE_NORMAL
#define SSA3000X_VAL_MARKER_TYPE_DELTA                             IVISPECAN_VAL_MARKER_TYPE_DELTA
#define SSA3000X_VAL_MARKER_TYPE_OFF                               (IVISPECAN_VAL_MARKER_TYPE_SPECIFIC_EXT_BASE+1)
    
/*- Defined values for ssa3000x_AcquisitionStatus ------------------------*/
#define SSA3000X_VAL_ACQUISITION_STATUS_COMPLETE                   IVISPECAN_VAL_ACQUISITION_STATUS_COMPLETE            
#define SSA3000X_VAL_ACQUISITION_STATUS_IN_PROGRESS                IVISPECAN_VAL_ACQUISITION_STATUS_IN_PROGRESS         
#define SSA3000X_VAL_ACQUISITION_STATUS_UNKNOWN                    IVISPECAN_VAL_ACQUISITION_STATUS_UNKNOWN   

/* Instrument specific attribute value definitions */

/*- Defined values for attribute SSA3000X_ATTR_INPUT_IMPEDANCE -*/
#define SSA3000X_VAL_INPUT_IMPEDANCE_50_OHM   (50)
#define SSA3000X_VAL_INPUT_IMPEDANCE_75_OHM   (75)

/*- Defined values for attribute SSA3000X_ATTR_MARKER_PEAK_SEARCH -*/
#define SSA3000X_VAL_MARKER_SEARCH_HIGHEST          (1)
#define SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK_LEFT   (2)
#define SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK_RIGHT  (3)
#define SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK        (4)

/*- Defined values for attribute SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING -*/
#define SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_CENTER   (1)
#define SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_START    (2)
#define SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_STOP     (3)

/*- Defined values for attribute SSA3000X_ATTR_MARKER_FUNCTION -*/
#define SSA3000X_VAL_MARKER_FUNCTION_FCOUNT   (1)
#define SSA3000X_VAL_MARKER_FUNCTION_NOISE    (2)
#define SSA3000X_VAL_MARKER_FUNCTION_NDB   	 3
#define SSA3000X_VAL_MARKER_FUNCTION_OFF      (4)

/*- Defined values for attribute SSA3000X_ATTR_PEAK_SEARCH_TYPE -*/
#define SSA3000X_VAL_PEAK_SEARCH_MODE_MAXIMUM   (1)
#define SSA3000X_VAL_PEAK_SEARCH_MODE_MINIMUM   (2)

/*- Defined values for attribute SSA3000X_ATTR_MARKER_TRACE -*/
#define SSA3000X_VAL_TRACE_NAME_TRACE_1   ("TRACE1")
#define SSA3000X_VAL_TRACE_NAME_TRACE_2   ("TRACE2")
#define SSA3000X_VAL_TRACE_NAME_TRACE_3   ("TRACE3")
#define SSA3000X_VAL_TRACE_NAME_TRACE_4   ("TRACE4")

/*- Defined values for attribute SSA3000X_ATTR_MARKER_X_READOUT -*/
#define SSA3000X_VAL_MARKER_X_READOUT_FREQUENCY   (1)
#define SSA3000X_VAL_MARKER_X_READOUT_TIME        (2)
#define SSA3000X_VAL_MARKER_X_READOUT_PERIOD      (3)

/*- Defined values for attribute SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION -*/
#define SSA3000X_VAL_MARKER_DEMODULATION_FUNCTION_AM   (1)
#define SSA3000X_VAL_MARKER_DEMODULATION_FUNCTION_FM   (2)

/*- Defined values for attribute SSA3000X_ATTR_INSTRUMENT_MODE -*/
#define SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER           (1)
#define SSA3000X_VAL_INSTRUMENT_MODE_REFLECTION_MEASUREMENT      (2)
#define SSA3000X_VAL_INSTRUMENT_MODE_TG         				   (3)
#define SSA3000X_VAL_INSTRUMENT_MODE_EMI                         (4)

/*- Defined values for attribute SSA3000X_ATTR_MEASUREMENT_TYPE -*/
#define SSA3000X_VAL_MEASUREMENT_TYPE_CHP   (1)
#define SSA3000X_VAL_MEASUREMENT_TYPE_ACPR  (2)
#define SSA3000X_VAL_MEASUREMENT_TYPE_OBW   (3)
#define SSA3000X_VAL_MEASUREMENT_TYPE_TPOWER 4
#define SSA3000X_VAL_MEASUREMENT_TYPE_TOI    5 
#define SSA3000X_VAL_MEASUREMENT_TYPE_SM    (6)
#define SSA3000X_VAL_MEASUREMENT_TYPE_OFF   (7)

/*- Defined values for attribute SSA3000X_ATTR_AVERAGE_TYPE -*/
#define SSA3000X_VAL_AVERAGE_TYPE_LOGPOWER   (1)
#define SSA3000X_VAL_AVERAGE_TYPE_POWER      (2)
#define SSA3000X_VAL_AVERAGE_TYPE_VOLTAGE    (3)

/*- Defined values for attribute SSA3000X_ATTR_SWEEP_MODE -*/
#define SSA3000X_VAL_SWEEP_MODE_NORMAL   (1)
#define SSA3000X_VAL_SWEEP_MODE_FAST     (2)
#define SSA3000X_VAL_SWEEP_MODE_AUTO     (3)

/*- Defined values for attribute SSA3000X_ATTR_OBW_METHOD -*/
#define SSA3000X_VAL_OBW_METHOD_PERCENT   (1)
#define SSA3000X_VAL_OBW_METHOD_DBC       (2)

/*- Defined values for attribute SSA3000X_ATTR_TRACE_MATH_TYPE -*/
#define SSA3000X_VAL_TRACE_MATH_TYPE_OFF                              1
#define SSA3000X_VAL_TRACE_MATH_TYPE_X_MINUS_Y_PLUS_REF               2
#define SSA3000X_VAL_TRACE_MATH_TYPE_Y_MINUS_X_PLUS_REF               3
#define SSA3000X_VAL_TRACE_MATH_TYPE_Y_PLUS_X_PLUS_REF                4
#define SSA3000X_VAL_TRACE_MATH_TYPE_X_PLUS_CONST                     5
#define SSA3000X_VAL_TRACE_MATH_TYPE_X_MINUS_CONST                    6
    
/*- Defined values for attribute SSA3000X_ATTR_FREQUENCY_SPAN_MODE -*/
#define SSA3000X_VAL_FREQUENCY_SPAN_MODE_FULL       (1)
#define SSA3000X_VAL_FREQUENCY_SPAN_MODE_ZERO       (2)
#define SSA3000X_VAL_FREQUENCY_SPAN_MODE_PREVIOUS   (3)

#define SSA3000X_VAL_MODEL_SSA3000X                                 1


/****************************************************************************
*---------------- Instrument Driver Function Declarations -----------------*
****************************************************************************/

/*- Init and Close Functions -------------------------------------------*/
ViStatus _VI_FUNC  ssa3000x_init (ViRsrc resourceName, 
                                   ViBoolean IDQuery,
                                   ViBoolean resetDevice,
                                   ViSession *vi);
ViStatus _VI_FUNC  ssa3000x_InitWithOptions (ViRsrc resourceName, 
                                              ViBoolean IDQuery,
                                              ViBoolean resetDevice, 
                                              ViConstString optionString, 
                                              ViSession *newVi);
ViStatus _VI_FUNC  ssa3000x_close (ViSession vi);   

    /*- Coercion Info Functions --------------------------------------------*/
ViStatus _VI_FUNC  ssa3000x_GetNextCoercionRecord (ViSession vi,
                                                    ViInt32 bufferSize,
                                                    ViChar record[]);
    
    /*- Locking Functions --------------------------------------------------*/
ViStatus _VI_FUNC  ssa3000x_LockSession (ViSession vi, ViBoolean *callerHasLock);   
ViStatus _VI_FUNC  ssa3000x_UnlockSession (ViSession vi, ViBoolean *callerHasLock);
/*- Tracking Generator Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureNormalize(ViSession vi, 
                                               ViBoolean NormalizeEnable,
                                               ViInt32 NormalizeReferenceLevel, 
                                               ViInt32 NormalizeReferencePosition);
ViStatus _VI_FUNC ssa3000x_ConfigureTrackingGenerator(ViSession vi,
                                                       ViBoolean OutputEnabled, 
                                                       ViReal64 OutputPower, 
                                                       ViReal64 OutputPowerOffset);

/*- OBW Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureOBW(ViSession vi, 
                                         ViInt32 OBWMethod, 
                                         ViReal64 OBWPowerPercentage, 
                                         ViReal64 OBWPowerLevel);

/*- CHP Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureCHP(ViSession vi, 
                                         ViReal64 CenterFrequency,
                                         ViReal64 IntegrationBandwidth, 
                                         ViReal64 ChannelSpan);

/*- IviSpecAnBase Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencySpanMode (ViSession vi,  
                                                        ViInt32 FrequencySpanMode);
ViStatus _VI_FUNC ssa3000x_SetActiveTrace(ViSession vi, 
                                           ViConstString ActiveTrace);
ViStatus _VI_FUNC ssa3000x_FetchMeasurementACPR(ViSession vi, 
                                                 ViReal64* LowACP, 
                                                 ViReal64* LowACPR, 
                                                 ViReal64* UpperACP,
                                                 ViReal64* UpperACPR,
                                                 ViReal64* MainChannelPower);
ViStatus _VI_FUNC ssa3000x_FetchMeasurementCHP(ViSession vi,
                                                ViReal64* MainChannelPower,
                                                ViReal64* PowerDensity);
ViStatus _VI_FUNC ssa3000x_FetchMeasurementOBW (ViSession vi,
                                                 ViReal64* OccupiedBandwidth,
                                                 ViReal64* BandwidthCentroid,
                                                 ViReal64* XDbBandwidth);
ViStatus _VI_FUNC ssa3000x_ReadMeasurementACPR(ViSession vi,
                                                ViInt32 MaxTime,
                                                ViReal64* LowACP,
                                                ViReal64* LowACPR,
                                                ViReal64* UpperACP,
                                                ViReal64* UpperACPR, 
                                                ViReal64* MainChannelPower);
ViStatus _VI_FUNC ssa3000x_ReadMeasurementCHP(ViSession vi,
                                               ViInt32 MaxTime,
                                               ViReal64* MainChannelPower, 
                                               ViReal64* PowerDensity);
ViStatus _VI_FUNC ssa3000x_ReadMeasurementOBW (ViSession vi,
                                                ViInt32 MaxTime,
                                                ViReal64* OccupiedBandwidth, 
                                                ViReal64* BandwidthCentroid,
                                                ViReal64* XDbBandwidth);
ViStatus _VI_FUNC ssa3000x_ConfigureTrace(ViSession vi,
                                           ViBoolean TraceMathFunctionEnable,
                                           ViInt32 TraceMathType);
ViStatus _VI_FUNC ssa3000x_ConfigureVBWRBWRatio(ViSession vi,
                                                 ViBoolean RatioAuto,
                                                 ViReal64 Ratio);
ViStatus _VI_FUNC ssa3000x_ConfigureAverage(ViSession vi,
                                             ViBoolean AverageEnable,
                                             ViInt32 AverageCount, 
                                             ViInt32 AverageType,
                                             ViBoolean AverageDurationEnable,
                                             ViReal64 AverageDuration);
ViStatus _VI_FUNC ssa3000x_RestartTraceAverage(ViSession vi);
ViStatus _VI_FUNC ssa3000x_ConfigureMeasurementType(ViSession vi,
                                                     ViInt32 InstrumentMode,
                                                     ViInt32 MeasurementType);
ViStatus _VI_FUNC ssa3000x_Abort(ViSession vi);
ViStatus _VI_FUNC ssa3000x_AcquisitionStatus(ViSession vi,
                                              ViInt32* Status);
ViStatus _VI_FUNC ssa3000x_ConfigureAcquisition(ViSession vi,
                                                 ViBoolean SweepModeContinuous,
                                                 ViInt32 NumberOfSweeps, 
                                                 ViBoolean DetectorTypeAuto,
                                                 ViInt32 DetectorType,
                                                 ViInt32 VerticalScale);
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyCenterSpan(ViSession vi,
                                                         ViReal64 CenterFrequency,
                                                         ViReal64 Span);
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyOffset(ViSession vi,
                                                     ViReal64 FrequencyOffset);
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyStartStop(ViSession vi,
                                                        ViReal64 StartFrequency,
                                                        ViReal64 StopFrequency);
ViStatus _VI_FUNC ssa3000x_ConfigureLevel(ViSession vi,
                                           ViInt32 AmplitudeUnits,
                                           ViReal64 InputImpedance, 
                                           ViReal64 ReferenceLevel,
                                           ViReal64 ReferenceLevelOffset,
                                           ViBoolean AttenuationAuto, 
                                           ViReal64 Attenuation);
ViStatus _VI_FUNC ssa3000x_ConfigureSweepCoupling(ViSession vi, 
                                                   ViBoolean ResolutionBandwidthAuto,
                                                   ViReal64 ResolutionBandwidth, 
                                                   ViBoolean VideoBandwidthAuto,
                                                   ViReal64 VideoBandwidth,
                                                   ViBoolean SweepTimeAuto, 
                                                   ViReal64 SweepTime);
ViStatus _VI_FUNC ssa3000x_ConfigureTraceType(ViSession vi,
                                               ViConstString TraceName,
                                               ViInt32 TraceType);
ViStatus _VI_FUNC ssa3000x_FetchYTrace(ViSession vi,
                                        ViConstString TraceName,
                                        ViInt32 ArrayLength, 
                                        ViInt32* ActualPoints, 
                                        ViReal64 Amplitude[]);
ViStatus _VI_FUNC ssa3000x_GetTraceName(ViSession vi, 
                                         ViInt32 Index,
                                         ViInt32 NameBufferSize, 
                                         ViChar Name[]);
ViStatus _VI_FUNC ssa3000x_Initiate(ViSession vi);
ViStatus _VI_FUNC ssa3000x_QueryTraceSize(ViSession vi,
                                           ViConstString TraceName,
                                           ViInt32* TraceSize);
ViStatus _VI_FUNC ssa3000x_ReadYTrace(ViSession vi,
                                       ViConstString TraceName,
                                       ViInt32 MaxTimeMilliseconds, 
                                       ViInt32 ArrayLength,
                                       ViInt32* ActualPoints,
                                       ViReal64 Amplitude[]);

/*- ACPR Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureACPR(ViSession vi,
                                          ViReal64 CenterFrequency,
                                          ViReal64 MainIntergrationBandwidth);

/*- IviSpecAnMultitrace Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_AddTraces(ViSession vi,
                                      ViConstString DestinationTrace,
                                      ViConstString Trace1, 
                                      ViConstString Trace2);
ViStatus _VI_FUNC ssa3000x_CopyTrace(ViSession vi,
                                      ViConstString DestinationTrace,
                                      ViConstString SourceTrace);
ViStatus _VI_FUNC ssa3000x_ExchangeTraces(ViSession vi,
                                           ViConstString Trace1,
                                           ViConstString Trace2);
ViStatus _VI_FUNC ssa3000x_SubtractTraces(ViSession vi,
                                           ViConstString DestinationTrace,
                                           ViConstString Trace1, 
                                           ViConstString Trace2);

/*- IviSpecAnMarker Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureDemodulation(ViSession vi,
                                                  ViInt32 DemodulationFunction,
                                                  ViReal64 SpeakerVolume, 
                                                  ViReal64 DelayTime);
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerPeakSearch(ViSession vi,
                                                      ViBoolean MarkerContinuousPeakingEnable,
                                                      ViInt32 PeakSearchMode);
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerEnabled(ViSession vi,
                                                   ViBoolean MarkerEnabled,
                                                   ViConstString MarkerTraceName);
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerFrequencyCounter(ViSession vi,
                                                            ViBoolean Enabled,
                                                            ViReal64 Resolution);
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerSearch(ViSession vi,
                                                  ViReal64 PeakExcursion,
                                                  ViReal64 MarkerThreshold);
ViStatus _VI_FUNC ssa3000x_ConfigureSignalTrackEnabled(ViSession vi,
                                                        ViBoolean SignalTrackEnabled);
ViStatus _VI_FUNC ssa3000x_DisableAllMarkers(ViSession vi);
ViStatus _VI_FUNC ssa3000x_GetMarkerName(ViSession vi,
                                          ViInt32 Index,
                                          ViInt32 NameBufferSize, 
                                          ViChar Name[]);
ViStatus _VI_FUNC ssa3000x_MarkerSearch(ViSession vi,
                                         ViInt32 SearchType);
ViStatus _VI_FUNC ssa3000x_MoveMarker(ViSession vi,
                                       ViReal64 MarkerPosition);
ViStatus _VI_FUNC ssa3000x_QueryMarker(ViSession vi,
                                        ViReal64* MarkerPosition,
                                        ViReal64* MarkerAmplitude);
ViStatus _VI_FUNC ssa3000x_SetActiveMarker(ViSession vi,
                                            ViConstString ActiveMarker);
ViStatus _VI_FUNC ssa3000x_SetInstrumentFromMarker(ViSession vi,
                                                    ViInt32 InstrumentSetting);

/*- IviSpecAnTrigger Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureTriggerSource(ViSession vi,
                                                   ViInt32 TriggerSource);

/*- Measurement Group Functions ----------------------------------------------------*/

/*- IviSpecAnExternalTrigger Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureExternalTrigger(ViSession vi,
                                                     ViReal64 ExternalTriggerLevel,
                                                     ViInt32 ExternalTriggerSlope);

/*- IviSpecAnVideoTrigger Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureVideoTrigger(ViSession vi,
                                                  ViReal64 VideoTriggerLevel,
                                                  ViInt32 VideoTriggerSlope);

/*- IviSpecAnMarkerType Group Functions ----------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerType(ViSession vi,
                                                ViInt32 MarkerType,
                                                ViInt32 MarkerFunction);
ViStatus _VI_FUNC ssa3000x_QueryMarkerType(ViSession vi,
                                            ViInt32* MarkerType);

/*- Error Functions ----------------------------------------------------*/
ViStatus _VI_FUNC  ssa3000x_error_query (ViSession vi, 
                                          ViInt32 *errorCode,
                                          ViChar errorMessage[]);

ViStatus _VI_FUNC  ssa3000x_GetError (ViSession vi,
                                       ViStatus *code, 
                                       ViInt32 bufferSize,
                                       ViChar description[]);
ViStatus _VI_FUNC  ssa3000x_ClearError (ViSession vi);

ViStatus _VI_FUNC  ssa3000x_error_message (ViSession vi,
                                            ViStatus errorCode,
                                            ViChar errorMessage[256]);
    
    /*- Interchangeability Checking Functions ------------------------------*/
ViStatus _VI_FUNC ssa3000x_GetNextInterchangeWarning (ViSession vi, 
                                                       ViInt32 bufferSize, 
                                                       ViChar warnString[]);
ViStatus _VI_FUNC ssa3000x_ResetInterchangeCheck (ViSession vi);
ViStatus _VI_FUNC ssa3000x_ClearInterchangeWarnings (ViSession vi);

    /*- Utility Functions --------------------------------------------------*/
ViStatus _VI_FUNC ssa3000x_InvalidateAllAttributes (ViSession vi);
ViStatus _VI_FUNC  ssa3000x_reset (ViSession vi);
ViStatus _VI_FUNC  ssa3000x_ResetWithDefaults (ViSession vi);
ViStatus _VI_FUNC  ssa3000x_self_test (ViSession vi,
                                        ViInt16 *selfTestResult,
                                        ViChar selfTestMessage[]);
ViStatus _VI_FUNC  ssa3000x_revision_query (ViSession vi, 
                                             ViChar instrumentDriverRevision[],
                                             ViChar firmwareRevision[]);
ViStatus _VI_FUNC  ssa3000x_Disable (ViSession vi);
ViStatus _VI_FUNC  ssa3000x_WriteInstrData (ViSession vi,
                                             ViConstString writeBuffer); 
ViStatus _VI_FUNC  ssa3000x_ReadInstrData  (ViSession vi,
                                             ViInt32 numBytes, 
                                             ViChar rdBuf[],
                                             ViInt32 *bytesRead);

    /*- Set, Get, and Check Attribute Functions ----------------------------*/
ViStatus _VI_FUNC  ssa3000x_GetAttributeViInt32 (ViSession vi,
                                                  ViConstString channelName,
                                                  ViAttr attribute,
                                                  ViInt32 *value);
ViStatus _VI_FUNC  ssa3000x_GetAttributeViReal64 (ViSession vi,
                                                   ViConstString channelName,
                                                   ViAttr attribute,
                                                   ViReal64 *value);
ViStatus _VI_FUNC  ssa3000x_GetAttributeViString (ViSession vi,
                                                   ViConstString channelName,
                                                   ViAttr attribute,
                                                   ViInt32 bufSize,
                                                   ViChar value[]); 
ViStatus _VI_FUNC  ssa3000x_GetAttributeViSession (ViSession vi,
                                                    ViConstString channelName, 
                                                    ViAttr attribute,
                                                    ViSession *value);
ViStatus _VI_FUNC  ssa3000x_GetAttributeViBoolean (ViSession vi,
                                                    ViConstString channelName,
                                                    ViAttr attribute,
                                                    ViBoolean *value);

ViStatus _VI_FUNC  ssa3000x_SetAttributeViInt32 (ViSession vi,
                                                  ViConstString channelName,
                                                  ViAttr attribute,
                                                  ViInt32 value);
ViStatus _VI_FUNC  ssa3000x_SetAttributeViReal64 (ViSession vi,
                                                   ViConstString channelName,
                                                   ViAttr attribute,
                                                   ViReal64 value);
ViStatus _VI_FUNC  ssa3000x_SetAttributeViString (ViSession vi,
                                                   ViConstString channelName,
                                                   ViAttr attribute,
                                                   ViConstString value); 
ViStatus _VI_FUNC  ssa3000x_SetAttributeViSession (ViSession vi,
                                                    ViConstString channelName,
                                                    ViAttr attribute,
                                                    ViSession value);
ViStatus _VI_FUNC  ssa3000x_SetAttributeViBoolean (ViSession vi,
                                                    ViConstString channelName,
                                                    ViAttr attribute,
                                                    ViBoolean value);

ViStatus _VI_FUNC  ssa3000x_CheckAttributeViInt32 (ViSession vi,
                                                    ViConstString channelName,
                                                    ViAttr attribute,
                                                    ViInt32 value);
ViStatus _VI_FUNC  ssa3000x_CheckAttributeViReal64 (ViSession vi,
                                                     ViConstString channelName,
                                                     ViAttr attribute,
                                                     ViReal64 value);
ViStatus _VI_FUNC  ssa3000x_CheckAttributeViString (ViSession vi,
                                                     ViConstString channelName,
                                                     ViAttr attribute,
                                                     ViConstString value); 
ViStatus _VI_FUNC  ssa3000x_CheckAttributeViSession (ViSession vi,
                                                      ViConstString channelName,
                                                      ViAttr attribute,
                                                      ViSession value);
ViStatus _VI_FUNC  ssa3000x_CheckAttributeViBoolean (ViSession vi,
                                                      ViConstString channelName,
                                                      ViAttr attribute,
                                                      ViBoolean value);

/****************************************************************************
 *------------------------ Error And Completion Codes ----------------------*
 ****************************************************************************/

#define SSA3000X_WARN_MEASURE_UNCAL                    IVISPECAN_WARN_MEASURE_UNCAL 
#define SSA3000X_WARN_OVER_RANGE                       IVISPECAN_WARN_OVER_RANGE

#define SSA3000X_ERROR_MAX_TIME_EXCEEDED               IVISPECAN_ERROR_MAX_TIME_EXCEEDED
#define SSA3000X_ERROR_NOT_DELTA_MARKER                IVISPECAN_ERROR_NOT_DELTA_MARKER
#define SSA3000X_ERROR_MARKER_NOT_ENABLED              IVISPECAN_ERROR_MARKER_NOT_ENABLED

#define SSA3000X_WARNMSG_MEASURE_UNCAL                 IVISPECAN_WARNMSG_MEASURE_UNCAL
#define SSA3000X_WARNMSG_OVER_RANGE                    IVISPECAN_WARNMSG_OVER_RANGE

#define SSA3000X_ERRMSG_MAX_TIME_EXCEEDED              IVISPECAN_ERRMSG_MAX_TIME_EXCEEDED
#define SSA3000X_ERRMSG_NOT_DELTA_MARKER               IVISPECAN_ERRMSG_NOT_DELTA_MARKER
#define SSA3000X_ERRMSG_MARKER_NOT_ENABLED             IVISPECAN_ERRMSG_MARKER_NOT_ENABLED

#define SSA3000X_ERROR_CODES_AND_MSGS \
        {SSA3000X_ERROR_MAX_TIME_EXCEEDED              SSA3000X_ERROR_MAX_TIME_EXCEEDED}, \
        {SSA3000X_WARN_MEASURE_UNCAL                   SSA3000X_WARNMSG_MEASURE_UNCAL}, \
        {SSA3000X_WARN_OVER_RANGE                      SSA3000X_WARNMSG_OVER_RANGE}

                
#define SSA3000X_ERROR_TRACE_NOT_ENABLED               (IVI_SPECIFIC_ERROR_BASE + 1)

/**************************************************************************** 
 *---------------------------- End Include File ----------------------------* 
 ****************************************************************************/
#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif
#endif /* __SSA3000X_HEADER */     
