/***************************************************************************** 
 *  Copyright 2012-2014, National Instruments Corporation.  All Rights Reserved.  *
 *****************************************************************************/
 
/*****************************************************************************
 *  Siglent SSA3000X  Spectrum Analyzer Instrument Driver                               
 *  LabWindows/CVI Instrument Driver                                     
 *  Original Release: 2016/11/10                                  
 *  By: Sue, Siglent Technologies                             
 *      PH. 400-878-0807    Fax  +86-755-36615186                             
 *                                                                           
 *  Modification History:                                                    
 *                                                                           
 *       10/11/2016- Instrument Driver Created. 
 *       10/11/2016- Porting to 64-bits driver. 
 *****************************************************************************/

#include <ansi_c.h>
#include <string.h>
#include <stdio.h>  
#include <formatio.h>
#include "ssa3000x.h"

/*****************************************************************************
 *--------------------- Hidden Attribute Declarations -----------------------*
 *****************************************************************************/

#define SSA3000X_ATTR_OPC_TIMEOUT                          (IVI_SPECIFIC_PRIVATE_ATTR_BASE + 1L)                    /* ViInt32   */
#define SSA3000X_ATTR_USE_SPECIFIC_SIMULATION              (IVI_INHERENT_ATTR_BASE + 23L)                           /* ViBoolean */
#define SSA3000X_ATTR_IO_SESSION                           (IVI_INHERENT_ATTR_BASE + 322L)                          /* ViSession */
#define SSA3000X_ATTR_OPC_CALLBACK                         (IVI_SPECIFIC_PRIVATE_ATTR_BASE + 6L)                    /* ViAddr    */
#define SSA3000X_ATTR_CHECK_STATUS_CALLBACK                (IVI_SPECIFIC_PRIVATE_ATTR_BASE + 7L)                    /* ViAddr    */
#define SSA3000X_ATTR_USER_INTERCHANGE_CHECK_CALLBACK      (IVI_SPECIFIC_PRIVATE_ATTR_BASE + 8L)                    /* ViAddr    */


/*****************************************************************************
 *---------------------------- Useful Macros --------------------------------*
 *****************************************************************************/

    /*- Float precision -----------------------------------------------------*/
#define FLOAT_PRECISION                         0.000001        

    /*- I/O buffer size -----------------------------------------------------*/
#define BUFFER_SIZE                             512L        


    /*- 488.2 Event Status Register (ESR) Bits ------------------------------*/
#define IEEE_488_2_ERROR_MASK                   0x3C

    /*- Instrument Model Marcos ---------------------------------------------*/
#define NOT_SUPPORTED                           -1

/*- Defined values for hidden attribute SSA3000X_ATTR_INST_MODEL -*/
#define SSA3000X_VAL_MODEL_SSA3000X                                     1 
    
    /*- List of channels passed to the Ivi_BuildChannelTable function -------*/ 
#define CHANNEL_LIST                            "1"
    /*- Repeated capabilities definition and lists of values passed to the Ivi_BuildRepCapTable function ------*/
#define MARKER_REP_CAP_NAME                    "Marker"
#define MARKER_LIST                            "MARKER1,MARKER2,MARKER3,MARKER4"        
#define DEFAULT_ACTIVE_MARKER                  "MARKER1"

#define TRACE_REP_CAP_NAME                     "Trace"
#define TRACE_LIST                             "TRACE1,TRACE2,TRACE3,TRACE4"        
        

    /*- Default definition of ID Query Response for simulation --------------*/
#define SSA3000X_SIMULATION_ID_QUERY                       


    /*- Macros for access to enum range table -----------------------------------*/
#define ssa3000x_GetCmdFromIntValue(value, table, cmd) \
        Ivi_GetViInt32EntryFromValue (value, table, VI_NULL, VI_NULL,\
                                      VI_NULL, VI_NULL, cmd, VI_NULL)

#define ssa3000x_GetCmdFromRealValue(value, table, cmd) \
        Ivi_GetViReal64EntryFromValue (value, table, VI_NULL, VI_NULL,\
                                       VI_NULL, VI_NULL, cmd, VI_NULL)

#define ssa3000x_GetValueFromCmd(buffer, table, value) \
        Ivi_GetViInt32EntryFromString (buffer, table, value, VI_NULL,\
        VI_NULL, VI_NULL, VI_NULL)

#define INSTRUMENT_MODE_IS_SA_TG(instrMode)\
        (( instrMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) || \
        ( instrMode == SSA3000X_VAL_INSTRUMENT_MODE_TG))

#define MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measType) \
        ((( instrMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) && \
        ( measType != SSA3000X_VAL_MEASUREMENT_TYPE_SM )) || \
        ( instrMode == SSA3000X_VAL_INSTRUMENT_MODE_TG))

/*****************************************************************************/
/*= Typedefs for string-value-revision tables.                     ========= */
/*****************************************************************************/
typedef struct {ViInt32       value;        /* Attribute ID */ 
                ViConstString string;       /* Command */
                ViConstString repCommand;   /* Extension for Reapted Command */
} ssa3000xStringValueEntry;

typedef ssa3000xStringValueEntry ssa3000xStringValueTable[50];

/*- Macros for the wrapper of empty channel name */
#define VALID_CHANNELNAME(channelName) \
        (VI_NULL == channelName ? "" : channelName)

static ssa3000xStringValueTable ssa3000xEnum_commands = 
{   /* Attribute ID,        SCPI command          */
    {SSA3000X_ATTR_TRACE_MATH_TYPE,                                       ":TRAC:MATH:TYPE",                      ""},
    {SSA3000X_ATTR_AVERAGE_TYPE,                                          ":AVER:TYPE",                           ""},
    {SSA3000X_ATTR_MEASUREMENT_TYPE,                                      ":INST:MEAS",                           ""},
    {SSA3000X_ATTR_INSTRUMENT_MODE,                                       ":INST",                                ""},
    {SSA3000X_ATTR_AMPLITUDE_UNITS,                                       ":UNIT:POW",                            ""},
    {SSA3000X_ATTR_DETECTOR_TYPE,                                         ":DET:",                                ""},
    {SSA3000X_ATTR_SWEEP_MODE,                                            ":SWE:MODE",                            ""},
    {SSA3000X_ATTR_TRACE_TYPE,                                            ":",                                    ":MODE"},
    {SSA3000X_ATTR_VERTICAL_SCALE,                                        ":DISP:WIND:TRAC:Y:SPAC",               ""},
    {SSA3000X_ATTR_OBW_METHOD,                                            ":OBW:METH",                            ""},
    {SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION,                          ":DEM",                  				""},
    {SSA3000X_ATTR_MARKER_X_READOUT,                                      ":CALC:",                               ":X:READ"},
    {SSA3000X_ATTR_PEAK_SEARCH_TYPE,                                      ":CALC:MARK:PEAK:SEAR:MODE",            ""},
    {SSA3000X_ATTR_MARKER_FUNCTION,                                       ":CALC:",                               ":FUNC" },    
    {SSA3000X_ATTR_TRIGGER_SOURCE,                                        ":TRIG:SOUR",                           ""},
    {SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE,                                ":TRIG:RFB:SLOP",                       ""},
    {SSA3000X_ATTR_MARKER_TYPE,                                           ":CALC:",                               ":MODE"},
    {VI_NULL,                                                              VI_NULL,                                VI_NULL}
};

static ssa3000xStringValueTable ssa3000xViBoolean_commands = 
{   /* Attribute ID,        SCPI command          */
    {SSA3000X_ATTR_VBW_RBW_RATIO_AUTO,                                    ":BWID:VID:RAT:AUTO",                   ""},
    {SSA3000X_ATTR_AVERAGE_DURATION_ENABLE,                               ":AVER:",                               ":DUR:STAT"},
    {SSA3000X_ATTR_AVERAGE_ENABLE,                                        ":AVER:",                               ""},
    {SSA3000X_ATTR_ATTENUATION_AUTO,                                      ":POW:ATT:AUTO",                        ""},
    {SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO,                             ":BWID:AUTO",                            ""},
    {SSA3000X_ATTR_SWEEP_MODE_CONTINUOUS,                                 ":INIT:CONT",                           ""},
    {SSA3000X_ATTR_SWEEP_TIME_AUTO,                                       ":SWE:TIME:AUTO",                       ""},
    {SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO,                                  ":BWID:VID:AUTO",                       ""},
    {SSA3000X_ATTR_TG_NORMALIZE_ENABLE,                                   ":CALC:NTD",                            ""},
    {SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE,                            ":OUTP",                                ""},
    {SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE,                      ":CALC:",                               ":CPE"},
    {SSA3000X_ATTR_MARKER_ENABLED,                                        ":CALC:",                               ":STAT"},
    {SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED,                      ":CALC:",                               ":FCO"},
    //{SSA3000X_ATTR_PREAMPLIFIER_ENABLE,                                   ":POW:GAIN",                            ""},
    {VI_NULL,                                                              VI_NULL,                                VI_NULL}
};

static ssa3000xStringValueTable ssa3000xViReal64_commands = 
{   /* Attribute ID,        SCPI command          */
    {SSA3000X_ATTR_VBW_RBW_RATIO,                                         ":BAND:VID:RAT",                        ""},
    {SSA3000X_ATTR_AVERAGE_DURATION,                                      ":AVER:",                               ":DUR"},
    {SSA3000X_ATTR_ATTENUATION,                                           ":POW:ATT",                             ""},
    {SSA3000X_ATTR_INPUT_IMPEDANCE,                                       ":CORR:IMP",                            ""},  
    {SSA3000X_ATTR_FREQUENCY_START,                                       ":FREQ:STAR",                           ""},
    {SSA3000X_ATTR_FREQUENCY_STOP,                                        ":FREQ:STOP",                           ""},
    {SSA3000X_ATTR_FREQUENCY_OFFSET,                                      ":FREQ:OFFS",                           ""},
    {SSA3000X_ATTR_CENTER_FREQUENCY,                                      ":FREQ:CENT",                           ""},
    {SSA3000X_ATTR_FREQUENCY_SPAN,                                        ":FREQ:SPAN",                           ""},
    {SSA3000X_ATTR_REFERENCE_LEVEL,                                       ":DISP:WIND:TRAC:Y:RLEV",               ""},
    {SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET,                                ":DISP:WIND:TRAC:Y:RLEV:OFFS",          ""},
    {SSA3000X_ATTR_RESOLUTION_BANDWIDTH,                                  ":BWID",                                ""},
    {SSA3000X_ATTR_SWEEP_TIME,                                            ":SWE:TIME",                            ""},
    {SSA3000X_ATTR_VIDEO_BANDWIDTH,                                       ":BWID:VID",                            ""},
    {SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET,                            ":SOUR:CORR:OFFS",                      ""},
    {SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE,                                   ":SOUR:POW",                            ""},
    {SSA3000X_ATTR_OBW_POWER_LEVEL,                                       ":OBW:XDB",                             ""},
    {SSA3000X_ATTR_OBW_POWER_PERCENTAGE,                                  ":OBW:PERC",                            ""},
    {SSA3000X_ATTR_CHP_CHANNEL_SPAN,                                      ":CHP:FREQ:SPAN",                      ""},
    {SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH,                             ":CHP:BWID:INT",                        ""},
    {SSA3000X_ATTR_CHP_CENTER_FREQUENCY,                                  ":CHP:FREQ:CENT",                       ""},
    {SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH,              ":ACPR:BWID:INT",                       ""},
    {SSA3000X_ATTR_ACPR_CENTER_FREQUENCY,                                 ":FREQ:CENT",                     		""},
    {SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME,                        ":DEM:TIME",             			  	""},
    {SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME,                    ":DEM:VOL",                				""},
    {SSA3000X_ATTR_MARKER_POSITION,                                       ":CALC:",                               ":X"},
    {SSA3000X_ATTR_MARKER_AMPLITUDE,                                      ":CALC:",                               ":Y"},
    {SSA3000X_ATTR_PEAK_EXCURSION,                                        ":CALC:MARK:PEAK:EXC",                  ""},
    {SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL,                                   ":TRIG:VID:LEV",                        ""},
    //{SSA3000X_ATTR_EXTERNAL_GAIN,                                         ":CORR:OFFS",                           ""},
    {VI_NULL,																VI_NULL,							VI_NULL}
};

static ssa3000xStringValueTable ssa3000xViInt32_commands = 
{   /* Attribute ID,        SCPI command          */
    {SSA3000X_ATTR_AVERAGE_COUNT,                                         ":AVER:",                               ":COUN"},   
    {SSA3000X_ATTR_TG_NORMAILIZE_REFERENCE_POSITION,                      ":DISP:WIND:TRAC:Y:NRP",                ""},
    {SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL,                          ":DISP:WIND:TRAC:Y:NRL",                ""},
    {VI_NULL,															  VI_NULL,								VI_NULL}
};



/*****************************************************************************
 *----------------- Value Definition and Range Tables -----------------------*
 *****************************************************************************/

static IviRangeTableEntry attrAmplitudeUnitsRangeTableEntries[] =
	{
		{SSA3000X_VAL_AMPLITUDE_UNITS_DBM, 0, 0, "DBM", 0},
		{SSA3000X_VAL_AMPLITUDE_UNITS_DBMV, 0, 0, "DBMV", 1},
		{SSA3000X_VAL_AMPLITUDE_UNITS_DBUV, 0, 0, "DBUV", 2},
		{SSA3000X_VAL_AMPLITUDE_UNITS_VOLT, 0, 0, "V", 3},
		{SSA3000X_VAL_AMPLITUDE_UNITS_WATT, 0, 0, "W", 4},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrAmplitudeUnitsRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrAmplitudeUnitsRangeTableEntries,
	};

static IviRangeTableEntry attrDetectorTypeRangeTableEntries[] =
	{
		{SSA3000X_VAL_DETECTOR_TYPE_AVERAGE, 0, 0, "AVERage", 0},
		{SSA3000X_VAL_DETECTOR_TYPE_MAX_PEAK, 0, 0, "POSitive", 1},
		{SSA3000X_VAL_DETECTOR_TYPE_MIN_PEAK, 0, 0, "NEGative", 2},
		{SSA3000X_VAL_DETECTOR_TYPE_SAMPLE, 0, 0, "SAMPle", 3},
		{SSA3000X_VAL_DETECTOR_TYPE_NORMAL, 0, 0, "NORMAL", 4},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrDetectorTypeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrDetectorTypeRangeTableEntries,
	};

static IviRangeTableEntry attrTraceTypeRangeTableEntries[] =
	{
		{SSA3000X_VAL_TRACE_TYPE_CLEAR_WRITE, 0, 0, "WRITe", 0},
		{SSA3000X_VAL_TRACE_TYPE_MAX_HOLD, 0, 0, "MAXHold", 1},
		{SSA3000X_VAL_TRACE_TYPE_MIN_HOLD, 0, 0, "MINHold", 2},
		{SSA3000X_VAL_TRACE_TYPE_VIEW, 0, 0, "VIEW", 3},
		{SSA3000X_VAL_TRACE_TYPE_STORE, 0, 0, "BLANk", 4},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrTraceTypeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrTraceTypeRangeTableEntries,
	};

static IviRangeTableEntry attrVerticalScaleRangeTableEntries[] =
    {
        {SSA3000X_VAL_VERTICAL_SCALE_LINEAR, 0, 0, "LIN", 0},
        {SSA3000X_VAL_VERTICAL_SCALE_LOGARITHMIC, 0, 0, "LOG", 1},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrVerticalScaleRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrVerticalScaleRangeTableEntries,
    };

static IviRangeTableEntry attrTriggerSourceRangeTableEntries[] =
	{
		{SSA3000X_VAL_TRIGGER_SOURCE_EXTERNAL, 0, 0, "EXTernal", 0},
		{SSA3000X_VAL_TRIGGER_SOURCE_IMMEDIATE, 0, 0, "IMMediate", 1},
		{SSA3000X_VAL_TRIGGER_SOURCE_VIDEO, 0, 0, "VIDeo", 2},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrTriggerSourceRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrTriggerSourceRangeTableEntries,
	};

static IviRangeTableEntry attrExternalTriggerSlopeRangeTableEntries[] =
	{
		{SSA3000X_VAL_EXTERNAL_TRIGGER_SLOPE_POSITIVE, 0, 0, "POSitive", 0},
		{SSA3000X_VAL_EXTERNAL_TRIGGER_SLOPE_NEGATIVE, 0, 0, "NEGative", 1},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrExternalTriggerSlopeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrExternalTriggerSlopeRangeTableEntries,
	};

static IviRangeTableEntry attrVideoTriggerSlopeRangeTableEntries[] =
    {
        {SSA3000X_VAL_VIDEO_TRIGGER_SLOPE_POSITIVE, 0, 0, "", 0},
        {SSA3000X_VAL_VIDEO_TRIGGER_SLOPE_NEGATIVE, 0, 0, "", 1},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrVideoTriggerSlopeRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrVideoTriggerSlopeRangeTableEntries,
    };

static IviRangeTableEntry attrMarkerTypeRangeTableEntries[] =
	{
		{SSA3000X_VAL_MARKER_TYPE_NORMAL, 0, 0, "POSition", 0},
		{SSA3000X_VAL_MARKER_TYPE_DELTA, 0, 0, "DELTa", 1},
		{SSA3000X_VAL_MARKER_TYPE_OFF, 0, 0, "OFF", 2},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrMarkerTypeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerTypeRangeTableEntries,
	};

static IviRangeTableEntry attrInputImpedanceRangeTableEntries[] =
    {
        {SSA3000X_VAL_INPUT_IMPEDANCE_50_OHM, 0, 0, "OHM50", 0},
        {SSA3000X_VAL_INPUT_IMPEDANCE_75_OHM, 0, 0, "OHM75", 1},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrInputImpedanceRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrInputImpedanceRangeTableEntries,
    };

static IviRangeTableEntry attrResolutionBandwidthRangeTableEntries[] =
    {
        {10, 3e6, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrResolutionBandwidthRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrResolutionBandwidthRangeTableEntries,
    };

static IviRangeTableEntry attrVideoBandwidthRangeTableEntries[] =
    {
        {1, 3e6, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrVideoBandwidthRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrVideoBandwidthRangeTableEntries,
    };

static IviRangeTableEntry attrUnitsPerDivisionRangeTableEntries[] =
    {
        {1, 1, 1, "", 0},
        {2, 2, 2, "", 1},
        {3, 5, 5, "", 2},
        {6, 10, 10, "", 3},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrUnitsPerDivisionRangeTable =
    {
        IVI_VAL_COERCED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrUnitsPerDivisionRangeTableEntries,
    };

static IviRangeTableEntry attrMarkerPeakSearchRangeTableEntries[] =
    {
        {SSA3000X_VAL_MARKER_SEARCH_HIGHEST, 0, 0, "", 0},
        {SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK_LEFT, 0, 0, "LEFT", 1},
        {SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK_RIGHT, 0, 0, "RIGH", 2},
        {SSA3000X_VAL_MARKER_SEARCH_NEXT_PEAK, 0, 0, "NEXT", 3},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrMarkerPeakSearchRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerPeakSearchRangeTableEntries,
    };

static IviRangeTableEntry attrMarkerInstrumentSettingRangeTableEntries[] =
    {
        {SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_CENTER, 0, 0, "CENT", 0},
        {SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_START, 0, 0, "STAR", 1},
        {SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_STOP, 0, 0, "STOP", 2},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrMarkerInstrumentSettingRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerInstrumentSettingRangeTableEntries,
    };

static IviRangeTableEntry attrMarkerFunctionRangeTableEntries[] =
	{
		{SSA3000X_VAL_MARKER_FUNCTION_FCOUNT, 0, 0, "FCOunt", 0},
		{SSA3000X_VAL_MARKER_FUNCTION_NOISE, 0, 0, "NOISe", 1},
		{SSA3000X_VAL_MARKER_FUNCTION_NDB, 0, 0, "NDB", 2},
		{SSA3000X_VAL_MARKER_FUNCTION_OFF, 0, 0, "OFF", 3},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrMarkerFunctionRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerFunctionRangeTableEntries,
	};

static IviRangeTableEntry attrPeakSearchModeRangeTableEntries[] =
	{
		{SSA3000X_VAL_PEAK_SEARCH_MODE_MAXIMUM, 0, 0, "MAXimum", 0},
		{SSA3000X_VAL_PEAK_SEARCH_MODE_MINIMUM, 0, 0, "MINimum", 1},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrPeakSearchModeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrPeakSearchModeRangeTableEntries,
	};

static IviRangeTableEntry attrMarkerXReadoutRangeTableEntries[] =
    {
        {SSA3000X_VAL_MARKER_X_READOUT_FREQUENCY, 0, 0, "FREQ", 0},
        {SSA3000X_VAL_MARKER_X_READOUT_TIME, 0, 0, "TIME", 1},
        {SSA3000X_VAL_MARKER_X_READOUT_PERIOD, 0, 0, "PER", 2},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrMarkerXReadoutRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerXReadoutRangeTableEntries,
    };

static IviRangeTableEntry attrMarkerDemodulationFunctionRangeTableEntries[] =
    {
        {SSA3000X_VAL_MARKER_DEMODULATION_FUNCTION_AM, 0, 0, "AM", 0},
        {SSA3000X_VAL_MARKER_DEMODULATION_FUNCTION_FM, 0, 0, "FM", 1},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrMarkerDemodulationFunctionRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMarkerDemodulationFunctionRangeTableEntries,
    };

static IviRangeTableEntry attrInstrumentModeRangeTableEntries[] =
	{
		{SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER, 0, 0, "SA", 0},
		{SSA3000X_VAL_INSTRUMENT_MODE_REFLECTION_MEASUREMENT, 0, 0, "CAT", 1},
		{SSA3000X_VAL_INSTRUMENT_MODE_TG, 0, 0, "TG", 2},
		{SSA3000X_VAL_INSTRUMENT_MODE_EMI, 0, 0, "EMI", 3},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrInstrumentModeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrInstrumentModeRangeTableEntries,
	};

static IviRangeTableEntry attrMeasurementTypeRangeTableEntries[] =
	{
		{SSA3000X_VAL_MEASUREMENT_TYPE_ACPR, 0, 0, "ACPR", 0},
		{SSA3000X_VAL_MEASUREMENT_TYPE_CHP, 0, 0, "CHPower", 1},
		{SSA3000X_VAL_MEASUREMENT_TYPE_OBW, 0, 0, "OBW", 2},
		{SSA3000X_VAL_MEASUREMENT_TYPE_TPOWER, 0, 0, "TPOWer", 3},
		{SSA3000X_VAL_MEASUREMENT_TYPE_TOI, 0, 0, "TOI", 4},
		{SSA3000X_VAL_MEASUREMENT_TYPE_SM, 0, 0, "SPECtrogram", 5},
		{SSA3000X_VAL_MEASUREMENT_TYPE_OFF, 0, 0, "OFF", 6},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrMeasurementTypeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrMeasurementTypeRangeTableEntries,
	};

static IviRangeTableEntry attrAcprMainChannelIntergrationBandwidthRangeTableEntries[] =
    {
        {300, 25e6, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrAcprMainChannelIntergrationBandwidthRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrAcprMainChannelIntergrationBandwidthRangeTableEntries,
    };

static IviRangeTableEntry attrAverageCountRangeTableEntries[] =
    {
        {1, 8192, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrAverageCountRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrAverageCountRangeTableEntries,
    };

static IviRangeTableEntry attrAverageTypeRangeTableEntries[] =
    {
        {SSA3000X_VAL_AVERAGE_TYPE_LOGPOWER, 0, 0, "LOGP", 0},
        {SSA3000X_VAL_AVERAGE_TYPE_POWER, 0, 0, "POW", 1},
        {SSA3000X_VAL_AVERAGE_TYPE_VOLTAGE, 0, 0, "VOLT", 2},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrAverageTypeRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrAverageTypeRangeTableEntries,
    };

static IviRangeTableEntry attrVbwRbwRatioRangeTableEntries[] =
    {
        {0.00001, 3.0e6, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrVbwRbwRatioRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrVbwRbwRatioRangeTableEntries,
    };

static IviRangeTableEntry attrSweepModeRangeTableEntries[] =
    {
        {SSA3000X_VAL_SWEEP_MODE_NORMAL, 0, 0, "SWE", 0},
        {SSA3000X_VAL_SWEEP_MODE_FAST, 0, 0, "FFT", 1},
        {SSA3000X_VAL_SWEEP_MODE_AUTO, 0, 0, "AUTO", 2},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrSweepModeRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrSweepModeRangeTableEntries,
    };

static IviRangeTableEntry attrObwMethodRangeTableEntries[] =
    {
        {SSA3000X_VAL_OBW_METHOD_PERCENT, 0, 0, "PERC", 0},
        {SSA3000X_VAL_OBW_METHOD_DBC, 0, 0, "DBC", 1},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrObwMethodRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrObwMethodRangeTableEntries,
    };

static IviRangeTableEntry attrObwPowerPercentageRangeTableEntries[] =
    {
        {10, 99, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrObwPowerPercentageRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrObwPowerPercentageRangeTableEntries,
    };

static IviRangeTableEntry attrObwPowerLevelRangeTableEntries[] =
    {
        {0.1, 100, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrObwPowerLevelRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrObwPowerLevelRangeTableEntries,
    };

static IviRangeTableEntry attrTgNormailizeReferencePositionRangeTableEntries[] =
	{
		{0, 100, 0, "", 0},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrTgNormailizeReferencePositionRangeTable =
	{
		IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrTgNormailizeReferencePositionRangeTableEntries,
	};

static IviRangeTableEntry attrTraceMathTypeRangeTableEntries[] =
	{
		{SSA3000X_VAL_TRACE_MATH_TYPE_OFF, 0, 0, "Off", 0},
		{SSA3000X_VAL_TRACE_MATH_TYPE_X_MINUS_Y_PLUS_REF, 0, 0, "X-Y+Ref->Z", 1},
		{SSA3000X_VAL_TRACE_MATH_TYPE_Y_MINUS_X_PLUS_REF, 0, 0, "Y-X+Ref->Z", 2},
		{SSA3000X_VAL_TRACE_MATH_TYPE_Y_PLUS_X_PLUS_REF, 0, 0, "X+Y-Ref->Z", 3},
		{SSA3000X_VAL_TRACE_MATH_TYPE_X_PLUS_CONST, 0, 0, "X+Const->Z", 4},
		{SSA3000X_VAL_TRACE_MATH_TYPE_X_MINUS_CONST, 0, 0, "X-Const->Z", 5},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrTraceMathTypeRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrTraceMathTypeRangeTableEntries,
	};

static IviRangeTableEntry attrReferenceLevelOffsetRangeTableEntries[] =
    {
        {-327.6, 327.6, 0, "", 0},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrReferenceLevelOffsetRangeTable = 
    {
        IVI_VAL_RANGED,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrReferenceLevelOffsetRangeTableEntries,
    };

static IviRangeTableEntry attrFrequencySpanModeRangeTableEntries[] =
    {
        {SSA3000X_VAL_FREQUENCY_SPAN_MODE_FULL, 0, 0, "FULL", 0},
        {SSA3000X_VAL_FREQUENCY_SPAN_MODE_ZERO, 0, 0, "ZERO", 1},
        {SSA3000X_VAL_FREQUENCY_SPAN_MODE_PREVIOUS, 0, 0, "PREV", 2},
        {IVI_RANGE_TABLE_LAST_ENTRY}
    };

static IviRangeTable attrFrequencySpanModeRangeTable =
    {
        IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrFrequencySpanModeRangeTableEntries,
    };

static IviRangeTableEntry attrInstModelRangeTableEntries[] =
	{
		{SSA3000X_VAL_MODEL_SSA3000X, 0, 0, "", 1},
		{IVI_RANGE_TABLE_LAST_ENTRY}
	};

static IviRangeTable attrInstModelRangeTable =
	{
		IVI_VAL_DISCRETE,
        VI_TRUE,
        VI_TRUE,
        VI_NULL,
        attrInstModelRangeTableEntries,
	};


/*****************************************************************************
 *-------------- Utility Function Declarations (Non-Exported) ---------------*
 *****************************************************************************/

static ViStatus ssa3000x_IviInit (ViRsrc resourceName, ViBoolean IDQuery, 
                                     ViBoolean reset, ViSession vi);
static ViStatus ssa3000x_IviClose (ViSession vi);   

static ViStatus ssa3000x_InitAttributes (ViSession vi, ViInt32 instModel);
static ViStatus ssa3000x_DefaultInstrSetup (ViSession openInstrSession);
static ViStatus ssa3000x_CheckStatus (ViSession vi);
static ViStatus ssa3000x_WaitForOPC (ViSession vi, ViInt32 maxTime);
static ViStatus ssa3000x_GetDriverSetupOption (ViSession vi,
                                               ViConstString optionTag,
                                               ViInt32 optionValueSize,
                                               ViChar optionValue[]);

static ViBoolean ssa3000x_OnArrayList(ViAttr attributeId,
                                       ViAttr attrArray[]);
static ViStatus ssa3000x_ValidConfigCheck(ViSession vi,
                                           ViAttr attributeId);

    /*- File I/O Utility Functions -*/

static ViStatus ssa3000x_GetStringFromTable( ssa3000xStringValueTable table, ViInt32 value,
        ViConstString* string );

static ViStatus ssa3000x_GetActiveMarker(ViSession       vi,
                                          ViConstString*  pActiveMarker,
                                          ViBoolean       testState);
static ViStatus ssa3000x_GetActiveTrace(ViSession       vi,
                                         ViConstString*  pActiveMarker,
                                         ViBoolean       testState);
static ViStatus ssa3000x_RecalculateLevelToDBM(ViSession   vi,
                                                ViReal64    level,
                                                ViReal64*   levelDBM);
static ViStatus ssa3000x_ParseRealArray(ViSession vi,
                                         ViChar Buffer[], 
                                         ViInt32 ArrayLength, 
                                         ViInt32 *ActualPoints, 
                                         ViReal64 ResultData[]);

/*****************************************************************************
 *----------------- Callback Declarations (Non-Exported) --------------------*
 *****************************************************************************/

    /*- Global Session Callbacks --------------------------------------------*/
    
static ViStatus _VI_FUNC ssa3000x_CheckStatusCallback (ViSession vi, ViSession io);

    /*- Attribute callbacks -------------------------------------------------*/


static ViStatus _VI_FUNC ssa3000xEnum_ReadCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViInt32*        value);
static ViStatus _VI_FUNC ssa3000xEnum_WriteCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViInt32         value);

static ViStatus _VI_FUNC ssa3000xViBoolean_ReadCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViBoolean*      value);
static ViStatus _VI_FUNC ssa3000xViBoolean_WriteCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViBoolean       value);

static ViStatus _VI_FUNC ssa3000xViString_ReadCallback (
    ViSession           vi,
    ViSession           io,
    ViConstString       channelName,
    ViAttr              attributeId,
    const ViConstString cacheValue);

static ViStatus _VI_FUNC ssa3000xViReal64_WriteCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViReal64        value
);
static ViStatus _VI_FUNC ssa3000xViReal64_ReadCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViReal64*       value
);
static ViStatus _VI_FUNC ssa3000xViInt32_WriteCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViInt32         value
);
static ViStatus _VI_FUNC ssa3000xViInt32_ReadCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViInt32*        value
);



 
    
 
static ViStatus _VI_FUNC ssa3000xAttrDriverRevision_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    const ViConstString cacheValue);
static ViStatus _VI_FUNC ssa3000xAttrInstrumentManufacturer_ReadCallback (ViSession vi, 
                                                                            ViSession io,
                                                                            ViConstString channelName, 
                                                                            ViAttr attributeId,
                                                                            const ViConstString cacheValue);
static ViStatus _VI_FUNC ssa3000xAttrInstrumentModel_ReadCallback (ViSession vi, 
                                                                     ViSession io,
                                                                     ViConstString channelName, 
                                                                     ViAttr attributeId,
                                                                     const ViConstString cacheValue);

static ViStatus _VI_FUNC ssa3000xAttrFirmwareRevision_ReadCallback (ViSession vi, 
                                                                      ViSession io,
                                                                      ViConstString channelName, 
                                                                      ViAttr attributeId,
                                                                      const ViConstString cacheValue);
static ViStatus _VI_FUNC ssa3000xAttrIdQueryResponse_ReadCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName, 
                                                                     ViAttr attributeId, 
                                                                     const ViConstString cacheValue);


    
static ViStatus _VI_FUNC ssa3000xAttrAttenuation_CoerceCallback (ViSession vi,
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViReal64 value, ViReal64* coercedValue);
static ViStatus _VI_FUNC ssa3000xAttrReferenceLevel_CheckCallback (ViSession vi,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrVideoTriggerLevel_CheckCallback (ViSession vi, 
                                                                        ViConstString channelName,
                                                                        ViAttr attributeId,
                                                                        ViReal64 value);
static ViStatus _VI_FUNC ssa3000xAttrUnitsPerDivision_ReadCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId, 
                                                                     ViReal64 *value);      
static ViStatus _VI_FUNC ssa3000xAttrUnitsPerDivision_WriteCallback (ViSession vi,
                                                                      ViSession io, 
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId, 
                                                                      ViReal64 value);
static ViStatus _VI_FUNC ssa3000xAttrMarkerType_ReadCallback (ViSession vi,
                                                                ViSession io, 
                                                                ViConstString channelName,
                                                                ViAttr attributeId, 
                                                                ViInt32 *value);     
static ViStatus _VI_FUNC ssa3000xAttrMarkerType_WriteCallback (ViSession vi,
                                                                 ViSession io, 
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId, 
                                                                 ViInt32 value);
static ViStatus _VI_FUNC ssa3000xAttrSweepTime_CoerceCallback (ViSession vi,
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId,
                                                                 ViReal64 value, ViReal64* coercedValue);        
static ViStatus _VI_FUNC ssa3000xAttrMarkerFunction_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViInt32 *value);     
static ViStatus _VI_FUNC ssa3000xAttrMarkerFunction_WriteCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId, 
                                                                     ViInt32 value);     
static ViStatus _VI_FUNC ssa3000xAttrMarkerFrequencyCounterEnabled_ReadCallback (ViSession vi,
                                                                                   ViSession io, 
                                                                                   ViConstString channelName,
                                                                                   ViAttr attributeId, 
                                                                                   ViBoolean *value);        
static ViStatus _VI_FUNC ssa3000xAttrMarkerFrequencyCounterEnabled_WriteCallback (ViSession vi,
                                                                                    ViSession io, 
                                                                                    ViConstString channelName,
                                                                                    ViAttr attributeId, 
                                                                                    ViBoolean value);        
static ViStatus _VI_FUNC ssa3000xAttrMarkerPosition_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 *value);        
static ViStatus _VI_FUNC ssa3000xAttrMarkerPosition_WriteCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId, 
                                                                     ViReal64 value);    
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 *value);     
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_WriteCallback (ViSession vi,
                                                                      ViSession io, 
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId, 
                                                                      ViReal64 value);  
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_ReadCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId, 
                                                                     ViReal64 *value);     
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_WriteCallback (ViSession vi,
                                                                      ViSession io, 
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId, 
                                                                      ViReal64 value);      
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_ReadCallback (ViSession vi,
                                                                 ViSession io,
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId,
                                                                 const ViConstString cacheValue);        
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViConstString value);
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_CheckCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViConstString value);

static ViStatus _VI_FUNC ssa3000xAttrActiveMarker_CheckCallback (ViSession vi,
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViConstString value);

static ViStatus _VI_FUNC ssa3000xAttrActiveTrace_CheckCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViConstString value);

static ViStatus _VI_FUNC ssa3000xAttrAmplitudeUnits_ReadCallback (ViSession vi,
                                                                    ViSession io,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViInt32 *value);

static ViStatus _VI_FUNC ssa3000xAttrAmplitudeUnits_WriteCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrCenterFrequency_ReadCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrCenterFrequency_WriteCallback (ViSession vi,
                                                                      ViSession io,
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrDetectorType_ReadCallback (ViSession vi,
                                                                  ViSession io,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViInt32 *value);

static ViStatus _VI_FUNC ssa3000xAttrDetectorType_WriteCallback (ViSession vi,
                                                                   ViSession io,
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyOffset_ReadCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyOffset_WriteCallback (ViSession vi,
                                                                      ViSession io,
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrInputImpedance_ReadCallback (ViSession vi,
                                                                   ViSession io, 
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId, 
                                                                   ViReal64 *value);    

static ViStatus _VI_FUNC ssa3000xAttrInputImpedance_WriteCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencySpan_ReadCallback (ViSession vi,
                                                                   ViSession io,
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencySpan_WriteCallback (ViSession vi,
                                                                    ViSession io,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyStart_ReadCallback (ViSession vi,
                                                                    ViSession io,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyStart_WriteCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyStop_ReadCallback (ViSession vi,
                                                                   ViSession io,
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencyStop_WriteCallback (ViSession vi,
                                                                    ViSession io,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrMarkerAmplitude_ReadCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 *value);

static ViStatus _VI_FUNC ssa3000xAttrMarkerContinuousPeakingEnable_ReadCallback (ViSession vi,
                                                                                   ViSession io,
                                                                                   ViConstString channelName,
                                                                                   ViAttr attributeId,
                                                                                   ViBoolean *value);

static ViStatus _VI_FUNC ssa3000xAttrMarkerContinuousPeakingEnable_WriteCallback (ViSession vi,
                                                                                    ViSession io,
                                                                                    ViConstString channelName,
                                                                                    ViAttr attributeId,
                                                                                    ViBoolean value);

static ViStatus _VI_FUNC ssa3000xAttrMarkerInstrumentSetting_WriteCallback (ViSession vi,
                                                                              ViSession io,
                                                                              ViConstString channelName,
                                                                              ViAttr attributeId,
                                                                              ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrMarkerPeakSearch_WriteCallback (ViSession vi,
                                                                       ViSession io,
                                                                       ViConstString channelName,
                                                                       ViAttr attributeId,
                                                                       ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrMeasurementType_ReadCallback (ViSession vi,
                                                                     ViSession io,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViInt32 *value);

static ViStatus _VI_FUNC ssa3000xAttrMeasurementType_WriteCallback (ViSession vi,
                                                                      ViSession io,
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrTraceType_ReadCallback (ViSession vi,
                                                               ViSession io,
                                                               ViConstString channelName,
                                                               ViAttr attributeId,
                                                               ViInt32 *value);

static ViStatus _VI_FUNC ssa3000xAttrTraceType_WriteCallback (ViSession vi,
                                                                ViSession io,
                                                                ViConstString channelName,
                                                                ViAttr attributeId,
                                                                ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrTgNormalizeReferenceLevel_CoerceCallback (ViSession vi,
                                                                                 ViConstString channelName,
                                                                                 ViAttr attributeId,
                                                                                 ViInt32 value, ViInt32* coercedValue);
static ViStatus _VI_FUNC ssa3000xAttrTgOutputAmplitude_CoerceCallback (ViSession vi,
                                                                         ViConstString channelName,
                                                                         ViAttr attributeId,
                                                                         ViReal64 value, ViReal64* coercedValue);
static ViStatus _VI_FUNC ssa3000xAttrChpChannelSpan_CheckCallback (ViSession vi,
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 value);

static ViStatus _VI_FUNC ssa3000xAttrFrequencySpanMode_WriteCallback (ViSession vi,
                                                                        ViSession io,
                                                                        ViConstString channelName,
                                                                        ViAttr attributeId,
                                                                        ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrSweepMode_ReadCallback (ViSession vi,
                                                               ViSession io,
                                                               ViConstString channelName,
                                                               ViAttr attributeId,
                                                               ViInt32 *value);

static ViStatus _VI_FUNC ssa3000xAttrSweepMode_WriteCallback (ViSession vi,
                                                                ViSession io,
                                                                ViConstString channelName,
                                                                ViAttr attributeId,
                                                                ViInt32 value);

static ViStatus _VI_FUNC ssa3000xAttrDemodulationMode_ReadCallback ( ViSession vi,
                                                                      ViSession io,
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViInt32 *value);


                
/*****************************************************************************
 *------------ User-Callable Functions (Exportable Functions) ---------------*
 *****************************************************************************/
 
/*****************************************************************************
 * Function: ssa3000x_init   
 * Purpose:  VXIplug&play required function.  Calls the   
 *           ssa3000x_InitWithOptions function.   
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_init (ViRsrc resourceName, 
                                  ViBoolean IDQuery,
                                  ViBoolean resetDevice, 
                                  ViSession *newVi)
{   
    ViStatus    error = VI_SUCCESS;

    if (newVi == VI_NULL)
    {
        Ivi_SetErrorInfo (VI_NULL, VI_FALSE, IVI_ERROR_INVALID_PARAMETER, 
                          VI_ERROR_PARAMETER4, "Null address for Instrument Handle");
        checkErr( IVI_ERROR_INVALID_PARAMETER);
    }

    checkErr( ssa3000x_InitWithOptions (resourceName, IDQuery, resetDevice, 
                                        "", newVi));

Error:
	return error;
}

/*****************************************************************************
 * Function: ssa3000x_InitWithOptions                                       
 * Purpose:  This function creates a new IVI session and calls the 
 *           IviInit function.                                     
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_InitWithOptions(ViRsrc          resourceName,
                                            ViBoolean       IDQuery,
                                            ViBoolean       resetDevice,
                                            ViConstString   optionString,
                                            ViSession*      newVi)
{   
    ViStatus    error = VI_SUCCESS;
    ViSession   vi = VI_NULL;
    ViChar      newResourceName[IVI_MAX_MESSAGE_BUF_SIZE];
    ViChar      newOptionString[IVI_MAX_MESSAGE_BUF_SIZE];
    ViBoolean   isLogicalName;
    
    if (newVi == VI_NULL)
    {
        Ivi_SetErrorInfo (VI_NULL, VI_FALSE, IVI_ERROR_INVALID_PARAMETER, 
                          VI_ERROR_PARAMETER5, "Null address for Instrument Handle");
        checkErr( IVI_ERROR_INVALID_PARAMETER);
    }

    *newVi = VI_NULL;
    
    checkErr( Ivi_GetInfoFromResourceName( resourceName, (ViString)optionString,
                                           newResourceName,
                                           newOptionString,
                                           &isLogicalName));
    
        /* create a new interchangeable driver */
    checkErr( Ivi_SpecificDriverNew ("ssa3000x", newOptionString, &vi));  
    if (!isLogicalName)
    {
        ViInt32 oldFlag = 0;
        
        checkErr (Ivi_GetAttributeFlags (vi, IVI_ATTR_IO_RESOURCE_DESCRIPTOR, &oldFlag));
        checkErr (Ivi_SetAttributeFlags (vi, IVI_ATTR_IO_RESOURCE_DESCRIPTOR, oldFlag & 0xfffb | 0x0010));
        checkErr (Ivi_SetAttributeViString (vi, "", IVI_ATTR_IO_RESOURCE_DESCRIPTOR, 0, newResourceName));
    }
        /* init the driver */
    checkErr( ssa3000x_IviInit (newResourceName, IDQuery, resetDevice, vi)); 
    if (isLogicalName)
        checkErr( Ivi_ApplyDefaultSetup (vi));
    *newVi = vi;
    
Error:
    if (error < VI_SUCCESS)
	{
        Ivi_Dispose (vi);
	}
        
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_close                                                           
 * Purpose:  This function closes the instrument.                            
 *
 *           Note:  This function must unlock the session before calling
 *           Ivi_Dispose.
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_close (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_IviClose (vi));

Error:    
    Ivi_UnlockSession (vi, VI_NULL);
    Ivi_Dispose (vi);  

    return error;
}

/*****************************************************************************
 * Function: ssa3000x_reset                                                         
 * Purpose:  This function resets the instrument.                          
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_reset (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (!Ivi_Simulating(vi))                /* call only when locked */
    {
        ViSession   io = Ivi_IOSession(vi); /* call only when locked */
        
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));
        viCheckErr( viPrintf (io, ":SYSTem:PRESet"));
    }
    
    checkErr( ssa3000x_DefaultInstrSetup (vi));                                
    
    checkErr( ssa3000x_CheckStatus (vi));                                      

Error:
    Ivi_UnlockSession (vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_ResetWithDefaults
 * Purpose:  This function resets the instrument and applies default settings
 *           from the IVI Configuration Store based on the logical name
 *           from which the session was created.
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_ResetWithDefaults (ViSession vi)
{
    ViStatus error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    checkErr( ssa3000x_reset(vi));
    checkErr( Ivi_ApplyDefaultSetup(vi));
    
Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/**************************************************************************** 
 *  Function: ssa3000x_Disable
 *  Purpose:  This function places the instrument in a quiescent state as 
 *            quickly as possible.
 *
 *            Note:
 *            The instrument doesn't support this function.
 ****************************************************************************/
ViStatus _VI_FUNC ssa3000x_Disable (ViSession vi)
{
    ViStatus error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
Error:
    Ivi_UnlockSession (vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_self_test                                                       
 * Purpose:  This function executes the instrument self-test and returns the 
 *           result.                                                         
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_self_test (ViSession vi, ViInt16 *testResult, 
                                      ViChar testMessage[])
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (testResult == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Test Result");
    if (testMessage == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Test Message");

    if (!Ivi_Simulating(vi))                /* call only when locked */
    {
        ViSession   io = Ivi_IOSession(vi); /* call only when locked */
    
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));
        viCheckErr( viPrintf (io, "*TST?"));
            
        viCheckErr( viScanf (io, "%hd", testResult));
        strcpy (testMessage, ""); 
    }
    else
    {
        /* Simulate Self Test */
        *testResult = 0;
        strcpy (testMessage, "No error.");
    }
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_revision_query                                                  
 * Purpose:  This function returns the driver and instrument revisions.      
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_revision_query (ViSession vi, ViChar driverRev[], 
                                            ViChar instrRev[])
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (driverRev == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Driver Revision");
    if (instrRev == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Instrument Revision");

    checkErr( Ivi_GetAttributeViString (vi, VI_NULL, SSA3000X_ATTR_SPECIFIC_DRIVER_REVISION, 
                                        0, 256, driverRev));
    checkErr( Ivi_GetAttributeViString (vi, "", SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION, 
                                        0, 256, instrRev));
    checkErr( ssa3000x_CheckStatus (vi));

Error:    
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_error_query                                                     
 * Purpose:  This function queries the instrument error queue and returns   
 *           the result.                                                     
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_error_query (ViSession vi, ViInt32 *errCode, 
                                         ViChar errMessage[])
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    if (errCode == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Error Code");
    if (errMessage == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Error Message");

    if (!Ivi_Simulating(vi))                /* call only when locked */
    {
        ViSession   io = Ivi_IOSession(vi); /* call only when locked */
    
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));
        viCheckErr( viPrintf(io, ":SYST:ERR?"));
    
        viCheckErr( viScanf (io, "%ld,\"%256[^\"]", errCode, errMessage));
    
    }
    else
    {
        /* Simulate Error Query */
        *errCode = 0;
        strcpy (errMessage, "No error.");
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_error_message                                                  
 * Purpose:  This function translates the error codes returned by this       
 *           instrument driver into user-readable strings.  
 *
 *           Note:  The caller can pass VI_NULL for the vi parameter.  This 
 *           is useful if one of the init functions fail.
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_error_message (ViSession vi, ViStatus errorCode,
                                           ViChar errorMessage[256])
{
    ViStatus    error = VI_SUCCESS;
    
    static      IviStringValueTable errorTable = 
    {
            IVISPECAN_ERROR_CODES_AND_MSGS,
            {VI_NULL,                               VI_NULL}
    };
        
    if (vi)
        Ivi_LockSession(vi, VI_NULL);

        /* all VISA and IVI error codes are handled as well as codes in the table */
    if (errorMessage == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Error Message");

    checkErr( Ivi_GetSpecificDriverStatusDesc(vi, errorCode, errorMessage, errorTable));

Error:
    if (vi)
        Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_InvalidateAllAttributes
 * Purpose:  This function invalidates the cached value of all attributes.
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_InvalidateAllAttributes (ViSession vi)
{
    return Ivi_InvalidateAllAttributes(vi);
}

 
/*****************************************************************************
 * Function: ssa3000x_GetError and ssa3000x_ClearError Functions                       
 * Purpose:  These functions enable the instrument driver user to  
 *           get or clear the error information the driver associates with the
 *           IVI session.                                                        
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_GetError (ViSession vi, 
                                      ViStatus *errorCode, 
                                      ViInt32 bufferSize,
                                      ViChar description[])  
{
    ViStatus error = VI_SUCCESS;
    ViStatus primary = VI_SUCCESS,
             secondary = VI_SUCCESS;
    ViChar   elaboration[256] = "";
    ViChar   errorMessage[1024] = "";
    ViChar  *appendPoint = errorMessage;
    ViInt32  actualSize = 0;
    ViBoolean locked = VI_FALSE;

    /* Lock Session */
    if (vi != 0)
    {
        checkErr( Ivi_LockSession(vi, &locked));
    }

    /* Test for nulls and acquire error data */
    if (bufferSize != 0)
    {
        if (errorCode == VI_NULL)
        {
            viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Error");
        }
        if (description == VI_NULL)
        {
            viCheckParm( IVI_ERROR_INVALID_PARAMETER, 4, "Null address for Description");
        }
        checkErr( Ivi_GetErrorInfo (vi, &primary, &secondary, elaboration));
    }

    else
    {
        checkErr( Ivi_GetAttributeViString(vi, VI_NULL, IVI_ATTR_ERROR_ELABORATION, 0, 256, elaboration));
        checkErr( Ivi_GetAttributeViInt32(vi, VI_NULL, IVI_ATTR_SECONDARY_ERROR, 0, &secondary));
        checkErr( Ivi_GetAttributeViInt32(vi, VI_NULL, IVI_ATTR_PRIMARY_ERROR, 0, &primary));
    }
        
    /* Format data */
    if (primary != VI_SUCCESS)
    {
        ViChar msg[256] = "";
        checkErr( ssa3000x_error_message (vi, primary, msg));
        appendPoint += sprintf(appendPoint, "Primary Error: (Hex 0x%08X) %s\n", primary, msg);
    }
    
    if (secondary != VI_SUCCESS)
    {
        ViChar msg[256] = "";
        checkErr( ssa3000x_error_message (vi, secondary, msg));
        appendPoint += sprintf(appendPoint, "Secondary Error: (Hex 0x%08X) %s\n", secondary, msg);
    }
    
    if (elaboration[0])
    {
        sprintf(appendPoint, "Elaboration: %s", elaboration);
    }
    
    actualSize = (ViInt32) (strlen(errorMessage) + 1);
    
    /* Prepare return values */
    if (bufferSize == 0)
    {
        error = actualSize;
    }
    else 
    {
        if (bufferSize > 0)
        {
            if (actualSize > bufferSize)
            {
                error = actualSize;
                actualSize = bufferSize;
            }
        }
        memcpy(description, errorMessage, actualSize-1);
        description[actualSize-1] = '\0';
    }
    
    if (errorCode) 
    {
        *errorCode = primary;
    }
    
Error:
    /* Unlock Session */
    Ivi_UnlockSession (vi, &locked);
    return error;
}   

ViStatus _VI_FUNC ssa3000x_ClearError (ViSession vi)                                                        
{                                                                                                           
    return Ivi_ClearErrorInfo (vi);                                                                             
}

/*****************************************************************************
 * Function: ssa3000x_GetNextCoercionRecord                        
 * Purpose:  This function enables the instrument driver user to obtain
 *           the coercion information associated with the IVI session.                                                              
 *           This function retrieves and clears the oldest instance in which 
 *           the instrument driver coerced a value the instrument driver user
 *           specified to another value.                     
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_GetNextCoercionRecord (ViSession vi,
                                                  ViInt32 bufferSize,
                                                  ViChar  record[])
{
    return Ivi_GetNextCoercionString (vi, bufferSize, record);
}

/**************************************************************************** 
 *  Function: ssa3000x_GetNextInterchangeWarning,
 *            ssa3000x_ResetInterchangeCheck, and
 *            ssa3000x_ClearInterchangeWarnings
 *  Purpose:  These functions allow the user to retrieve interchangeability
 *            warnings, reset the driver's interchangeability checking 
 *            state, and clear all previously logged interchangeability warnings.
 ****************************************************************************/
ViStatus _VI_FUNC ssa3000x_GetNextInterchangeWarning (ViSession vi, 
                                                      ViInt32 bufferSize, 
                                                      ViChar warnString[])
{
    return Ivi_GetNextInterchangeCheckString (vi, bufferSize, warnString);
}

ViStatus _VI_FUNC ssa3000x_ResetInterchangeCheck (ViSession vi)
{
    return Ivi_ResetInterchangeCheck (vi);
}

ViStatus _VI_FUNC ssa3000x_ClearInterchangeWarnings (ViSession vi)
{
    return Ivi_ClearInterchangeWarnings (vi);
}

/*****************************************************************************
 * Function: ssa3000x_LockSession and ssa3000x_UnlockSession Functions                        
 * Purpose:  These functions enable the instrument driver user to lock the 
 *           session around a sequence of driver calls during which other
 *           execution threads must not disturb the instrument state.
 *                                                                          
 *           Note:  The callerHasLock parameter must be a local variable 
 *           initialized to VI_FALSE and passed by reference, or you can pass 
 *           VI_NULL.                     
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_LockSession (ViSession vi, ViBoolean *callerHasLock)  
{                                              
    return Ivi_LockSession(vi,callerHasLock);      
}                                              
ViStatus _VI_FUNC ssa3000x_UnlockSession (ViSession vi, ViBoolean *callerHasLock) 
{                                              
    return Ivi_UnlockSession(vi,callerHasLock);    
}
    

/*===========================================================================*
 *= IviSpecAn Tracking Generator Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureNormalize
 * Purpose:   Configures normalize settings. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureNormalize (ViSession vi, 
                                                ViBoolean NormalizeEnable, 
                                                ViInt32 NormalizeReferenceLevel, 
                                                ViInt32 NormalizeReferencePosition)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_TG_NORMALIZE_ENABLE,
                 0, NormalizeEnable), 2, "Normalize Enable");
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL,
                 0, NormalizeReferenceLevel), 3, "Normalize Reference Level");
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_TG_NORMAILIZE_REFERENCE_POSITION,
                 0, NormalizeReferencePosition), 4, "Normalize Reference Position");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureTrackingGenerator
 * Purpose:   This function configures the tracking generator, including the 
 *            output power, attenuation, amplitude offset, power sweep and output 
 *            power tracking. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureTrackingGenerator (ViSession vi,
                                                        ViBoolean OutputEnabled,
                                                        ViReal64 OutputPower, 
                                                        ViReal64 OutputPowerOffset)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE,
                 0, OutputEnabled), 2, "Output Enabled");
    if(OutputEnabled)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE,
                     0, OutputPower), 3, "Output Power");
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET,
                     0, OutputPowerOffset), 5, "Output Power Offset");                              
    }
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            



/*===========================================================================*
 *= IviSpecAn IviSpecAnBase Group Functions =============================*
 *===========================================================================*/ 

/*******************************************************************************
 * Function:  ssa3000x_ConfigureFrequencySpanMode
 * Purpose:   Sets the frequency span to full scale, zero span or the previous span setting. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencySpanMode (ViSession vi,  
                                                        ViInt32 FrequencySpanMode)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_SPAN_MODE,
                 0, FrequencySpanMode), 2, "Frequency Span Mode");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}

/*******************************************************************************
 * Function:  ssa3000x_SetActiveTrace
 * Purpose:   This function selects one of the available traces, and makes it the active trace. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_SetActiveTrace (ViSession vi, 
                                            ViConstString ActiveTrace)
{
    return Ivi_SetAttributeViString (vi, VI_NULL, SSA3000X_ATTR_ACTIVE_TRACE,
                                     IVI_VAL_DIRECT_USER_CALL, ActiveTrace);
}             
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureTrace
 * Purpose:   Configures trace settings. If TraceMathFunctionEnable is set to VI_FALSE,
 *            TraceMathType will have no function.
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureTrace (ViSession vi, 
                                            ViBoolean TraceMathFunctionEnable, 
                                            ViInt32 TraceMathType)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));     
    
    /* Check boolean parameter range. */
    if(TraceMathFunctionEnable != VI_TRUE && TraceMathFunctionEnable != VI_FALSE)
        viCheckParm(IVI_ERROR_INVALID_PARAMETER, 2, "Trace Math Function Enable");  
    
    if(TraceMathFunctionEnable == VI_TRUE)
    {
        viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_TRACE_MATH_TYPE,
                     0, TraceMathType), 3, "Trace Math Type");   
    }
    else
    {
        if (!Ivi_Simulating(vi)) 
        {
            ViSession   io = Ivi_IOSession(vi);   /* call only when locked */ 
            
            viCheckErr(viPrintf(io, ":TRAC:MATH:TYPE Off;"));        
        }
    }
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureVBWRBWRatio
 * Purpose:   This function configures the ratio of the video bandwidth to the 
 *            resolution bandwidth. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureVBWRBWRatio (ViSession vi, 
                                                  ViBoolean RatioAuto, 
                                                  ViReal64 Ratio)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO,
                 0, RatioAuto), 2, "Ratio Auto");
    if(!RatioAuto)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_VIDEO_BANDWIDTH,
                     0, Ratio), 3, "Ratio");                              
    }
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureAverage
 * Purpose:   Configures average settings. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureAverage (ViSession vi, 
                                              ViBoolean AverageEnable, 
                                              ViInt32 AverageCount,  
                                              ViInt32 AverageType, 
                                              ViBoolean AverageDurationEnable, 
                                              ViReal64 AverageDuration)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  active_trace;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE)); 
    
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, active_trace, SSA3000X_ATTR_AVERAGE_ENABLE,
                 0, AverageEnable), 2, "Average Enable");
    if(AverageEnable)
    {
        viCheckParm( Ivi_SetAttributeViInt32 (vi, active_trace, SSA3000X_ATTR_AVERAGE_COUNT,
                     0, AverageCount), 3, "Average Count");
        viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_AVERAGE_TYPE,
                     0, AverageType), 4, "Average Type");
        viCheckParm( Ivi_SetAttributeViBoolean (vi, active_trace, SSA3000X_ATTR_AVERAGE_DURATION_ENABLE,
                     0, AverageDurationEnable), 5, "Average Duration Enable");
        if(AverageDurationEnable)
        {
            viCheckParm( Ivi_SetAttributeViReal64 (vi, active_trace, SSA3000X_ATTR_AVERAGE_DURATION,
                         0, AverageDuration), 6, "Average Duration"); 
        }
    }
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_RestartTraceAverage
 * Purpose:   Restarts the trace average. This command is only available when average is on.
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_RestartTraceAverage (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  active_trace; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));
    
    if (!Ivi_Simulating(vi)) 
    {
        ViSession   io = Ivi_IOSession(vi);   /* call only when locked */ 
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));      
        viCheckErr(viPrintf(io, ":AVER:%s:CLE;", active_trace));        
    }                                  
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMeasurementType
 * Purpose:   This function selects the measurement type.
 *            
 *            Note:
 *            Please set the Instrument Mode to Measurement Type to 
 *            SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER when configuring 
 *            the Measurement Type. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMeasurementType (ViSession vi, 
                                                      ViInt32 InstrumentMode, 
                                                      ViInt32 MeasurementType)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE,
                 0, InstrumentMode), 2, "Instrument Mode");

    if (InstrumentMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER)
    {
        viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                     0, MeasurementType), 3, "Measurement Type");                              
    }

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_Abort
 * Purpose:   This function aborts a previously initiated measurement and 
 *            returns the spectrum analyzer to the idle state.
 *
 *            This function does not check the instrument status. Typically, 
 *            the end-user calls this function only in a sequence of calls 
 *            to other low-level driver functions. The sequence performs one 
 *            operation. The end-user uses the low-level functions to 
 *            optimize one or more aspects of interaction with the 
 *            instrument. To check the instrument status, call the 
 *            ssa3000x_error_query function at the conclusion of the sequence.
 *
 *            Notes:
 *            This instrument doesn't support this function.
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_Abort (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_AcquisitionStatus
 * Purpose:   This function determines and returns the status of an acquisition. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_AcquisitionStatus (ViSession vi, 
                                               ViInt32* Status)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     instStatus = SSA3000X_VAL_ACQUISITION_STATUS_UNKNOWN;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    if (Status == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null Address for Status");

    error = ssa3000x_WaitForOPC (vi, 200000);  

    if ( error == VI_SUCCESS)                   
        instStatus = SSA3000X_VAL_ACQUISITION_STATUS_COMPLETE;
Error:
    *Status = instStatus;
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureAcquisition
 * Purpose:   This function configures the acquisition attributes of the spectrum analyzer. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureAcquisition (ViSession vi, 
                                                  ViBoolean SweepModeContinuous, 
                                                  ViInt32 NumberOfSweeps,
                                                  ViBoolean DetectorTypeAuto, 
                                                  ViInt32 DetectorType, 
                                                  ViInt32 VerticalScale)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     instrMode = 0;
    ViInt32     measurementType = 0;
    ViConstString  active_trace; 
    
        ViSession io = VI_NULL;

        /* Do not lock here.  The caller manages the lock. */

    checkErr( Ivi_GetAttributeViSession (vi, VI_NULL, IVI_ATTR_IO_SESSION, 0, &io));

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
              0, &instrMode));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
              0, &measurementType));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_SWEEP_MODE_CONTINUOUS,
                     0, SweepModeContinuous), 2, "Sweep Mode Continuous");

        if ( measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM )
        {
            if (DetectorTypeAuto == VI_FALSE) 
            {
                checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));    
                viCheckParm( Ivi_SetAttributeViInt32 (vi, active_trace, SSA3000X_ATTR_DETECTOR_TYPE,
                             0, DetectorType), 5, "Detector Type");
            }
            
            viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_VERTICAL_SCALE,
                         0, VerticalScale), 6, "Vertical Scale");                              
        }

        checkErr( ssa3000x_CheckStatus (vi));
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureFrequencyCenterSpan
 * Purpose:   This function configures the frequency range defining the center 
 *            frequency and the frequency span. If the span corresponds to zero 
 *            Hertz, then the spectrum analyzer operates in time-domain mode. 
 *            Otherwise, the spectrum analyzer operates in frequency-domain mode,
 *            
 *            This function modifies the Frequency Start and Frequency Stop 
 *            attributes as follows:
 *            
 *            Frequency Start = CenterFrequency - Span / 2 
 *            Frequency Stop = CenterFrequency + Span / 2 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyCenterSpan (ViSession vi, 
                                                          ViReal64 CenterFrequency,
                                                          ViReal64 Span)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CENTER_FREQUENCY,
                 0, CenterFrequency), 2, "Center Frequency");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_SPAN,
                 0, Span), 3, "Span");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureFrequencyOffset
 * Purpose:   This function configures the Frequency Offset attribute of the 
 *            spectrum analyzer. This function affects the setting of the spectrum 
 *            analyzer's absolute frequencies, such as start, stop, center, and marker.
 *            It does not affect values such as span and delta marker, which are the 
 *            difference of frequencies. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyOffset (ViSession vi, 
                                                      ViReal64 FrequencyOffset)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    //error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureFrequencyStartStop
 * Purpose:   This function configures the frequency range defining its start 
 *            frequency and its stop frequency. If the start frequency is equal to 
 *            the stop frequency, then the spectrum analyzer operates in time-domain
 *            mode. Otherwise, the spectrum analyzer operates in frequency-domain mode. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureFrequencyStartStop (ViSession vi, 
                                                         ViReal64 StartFrequency, 
                                                         ViReal64 StopFrequency)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     result; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    viCheckErr( Ivi_CompareWithPrecision(0, StartFrequency, StopFrequency, &result)); 

    if ( result < 0 )
    {
       /* set stop first */
       viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_STOP,
                    0, StopFrequency), 3, "Stop Frequency");
            
       viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_START,
                    0,StartFrequency), 2, "Start Frequency");
    }
    else if ( result == 0 ) /* zero span */
    { 
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_SPAN,
                     0, 0.0), 3, "Frequency Span");

        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CENTER_FREQUENCY,
                     0, StartFrequency), 2, "Frequency Center");
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "The Start Frequency should be less than the Stop Frequency");
    }                            

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureLevel
 * Purpose:   This function configures the vertical attributes of the spectrum 
 *            analyzer. This corresponds to the Amplitude Units, Input Attenuation,
 *            Input Impedance, Reference Level, and Reference Level Offset attributes. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureLevel (ViSession vi, 
                                            ViInt32 AmplitudeUnits, 
                                            ViReal64 InputImpedance, 
                                            ViReal64 ReferenceLevel,
                                            ViReal64 ReferenceLevelOffset,
                                            ViBoolean AttenuationAuto,
                                            ViReal64 Attenuation)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_AMPLITUDE_UNITS,
                 0, AmplitudeUnits), 2, "Amplitude Units");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_INPUT_IMPEDANCE,
                 0, InputImpedance), 3, "Input Impedance");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_REFERENCE_LEVEL,
                 0, ReferenceLevel), 4, "Reference Level");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET,
                 0, ReferenceLevelOffset), 5, "Reference Level Offset");
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_ATTENUATION_AUTO,
                 0, AttenuationAuto), 6, "Attenuation Auto");
    if(!AttenuationAuto)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_ATTENUATION,
                     0, Attenuation), 7, "Attenuation");                              
    }
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureSweepCoupling
 * Purpose:   This function configures the coupling and sweeping attributes. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureSweepCoupling (ViSession vi, 
                                                    ViBoolean ResolutionBandwidthAuto,
                                                    ViReal64 ResolutionBandwidth, 
                                                    ViBoolean VideoBandwidthAuto,
                                                    ViReal64 VideoBandwidth, 
                                                    ViBoolean SweepTimeAuto, 
                                                    ViReal64 SweepTime)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO,
                 0, ResolutionBandwidthAuto), 2, "Resolution Bandwidth Auto");
    if(!ResolutionBandwidthAuto)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_RESOLUTION_BANDWIDTH,
                     0, ResolutionBandwidth), 3, "Resolution Bandwidth");
    }
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO,
                 0, VideoBandwidthAuto), 4, "Video Bandwidth Auto");
    if(!VideoBandwidthAuto)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_VIDEO_BANDWIDTH,
                     0, VideoBandwidth), 5, "Video Bandwidth");
    }
    viCheckParm( Ivi_SetAttributeViBoolean (vi, VI_NULL, SSA3000X_ATTR_SWEEP_TIME_AUTO,
                 0, SweepTimeAuto), 6, "Sweep Time Auto");
    if(!SweepTimeAuto)
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_SWEEP_TIME,
                     0, SweepTime), 7, "Sweep Time");                              
    }
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureTraceType
 * Purpose:   This function configures the Trace Type attribute. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureTraceType (ViSession vi, 
                                                ViConstString TraceName, 
                                                ViInt32 TraceType)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString   activeTrace;
    
    checkErr( Ivi_CoerceRepCapName (vi, TRACE_REP_CAP_NAME, TraceName, &TraceName));     
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    
    viCheckParm( Ivi_SetAttributeViString(vi, VI_NULL, SSA3000X_ATTR_ACTIVE_TRACE, 
                 0, TraceName), 2, "Trace Name");
    
    checkErr( ssa3000x_GetActiveTrace(vi, &activeTrace, VI_FALSE));     
    viCheckParm( Ivi_SetAttributeViInt32 (vi, activeTrace, SSA3000X_ATTR_TRACE_TYPE,
                 0, TraceType), 3, "Trace Type");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_FetchYTrace
 * Purpose:   This function returns the trace the spectrum analyzer acquires. The 
 *            trace is from a previously initiated acquisition. The user calls the 
 *            Initiate function to start an acquisition. The user calls the Acquisition 
 *            Status function to determine when the acquisition is complete.
 *            The user may call the Read Y Trace function instead of the Initiate function. 
 *            This function starts an acquisition, waits for the acquisition to complete,
 *            and returns the trace in one function call.
 *            
 *            The Amplitude array returns data that represents the amplitude of the signals
 *            obtained by sweeping from the start frequency to the stop frequency 
 *            (in frequency domain, in time domain the amplitude array is ordered from 
 *            beginning of sweep to end). The Amplitude Units attribute determines the units
 *            of the points in the Amplitude array.
 *            
 *            After this function executes, each element in the amplitude array parameter 
 *            is either a amplitude or a value indicating that the spectrum analyzer could 
 *            not sample an amplitude.
 *            This function does not check the instrument status. The user calls the Error 
 *            Query function at the conclusion of the sequence to check the instrument status. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_FetchYTrace (ViSession vi, 
                                         ViConstString TraceName,
                                         ViInt32 ArrayLength,
                                         ViInt32* ActualPoints, 
                                         ViReal64 Amplitude[])
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   traceName;
    ViString          *buffer = VI_NULL;
	ViString        traceName_tmp;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    /* Check Parameters, if necessary. */
    
    if (Amplitude == VI_NULL)
    {
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 5, "Null address for amplitude");
    }        
    if (ActualPoints == VI_NULL)
    {
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 4, "Null address for Actual Points");
    }
    if (ArrayLength <= 0)
    {
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "The array length must be greater than zero");
    }

    checkErr( Ivi_CoerceRepCapName (vi, TRACE_REP_CAP_NAME, TraceName, &traceName)); 

    if (!Ivi_Simulating (vi))               /* Call only when locked */
    {
        ViSession   io = Ivi_IOSession (vi); /* Call only when locked */
		
		viCheckErr(viSetBuf (io, VI_READ_BUF, 40000));
        
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));

        checkErr( Ivi_Alloc (vi, 40000, (ViAddr *)(&buffer)));
		
		if(!strncmp(traceName, "TRACE1", 6))
		{
			traceName_tmp = "1";
		}
		else if(!strncmp(traceName, "TRACE2", 6))
		{
			traceName_tmp = "2";
		}
		else if(!strncmp(traceName, "TRACE3", 6))
		{
			traceName_tmp = "3";
		}
		else if(!strncmp(traceName, "TRACE4", 6))
		{
			traceName_tmp = "4";
		}											   							
		viCheckErr( viQueryf(io, ":TRAC? %s", "%t", traceName_tmp, buffer));

        checkErr( ssa3000x_ParseRealArray(vi, (ViChar *)buffer, ArrayLength, ActualPoints, Amplitude));
    }                                                                                          
    else
    {
        #define SIMULATION_LEVEL                    -70.0
 
        ViInt32     number_of_points;
        ViInt32     i;
    
        checkErr( Ivi_GetAttributeViInt32( vi,
                                           traceName,
                                           SSA3000X_ATTR_TRACE_SIZE,
                                           0, &number_of_points));
    
        number_of_points = (number_of_points > ArrayLength) ? ArrayLength : number_of_points;

        for (i = 0; i < number_of_points; i++)
        {
            ViReal64    peak;

            if ((i > (3 * number_of_points/ 8)) && (i < (5 * number_of_points / 8)))
            {
                peak = 50.0 - 200.0 * pow((i - 3.0 * number_of_points / 8.0)/(2.0 * number_of_points / 8.0) - 0.5, 2.0);
            }
            else 
                peak = ((double)rand())/RAND_MAX;

            Amplitude[i] = SIMULATION_LEVEL + peak + ((double)rand())/RAND_MAX;
        }

        if (ActualPoints) *ActualPoints = i;   
     }

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    if (buffer != VI_NULL)
        Ivi_Free(vi, buffer);

    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_GetTraceName
 * Purpose:   This function returns the specific driver defined trace name that 
 *            corresponds to the one-based index that the user specifies. If the 
 *            driver defines a qualified trace name, this property returns the 
 *            qualified name. If the value that the user passes for the Index 
 *            parameter is less than one or greater than the value of the Trace
 *            Count attribute, the function returns an empty string in the Name 
 *            parameter and returns the Invalid Value error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_GetTraceName (ViSession vi, 
                                          ViInt32 Index, 
                                          ViInt32 NameBufferSize,
                                          ViChar Name[])
{
    ViStatus         error = VI_SUCCESS;
    ViConstString    traceName = VI_NULL;
    ViInt32          actualSize = 0;
    ViInt32          traceCount;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    /* Check Parameters */
    if (NameBufferSize != 0)
    {
        if (Name == VI_NULL)
        {
            viCheckParm( IVI_ERROR_INVALID_PARAMETER, 4, "Null address for Trace Name");
        }
    }
        
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_TRACE_COUNT, 0, &traceCount));
    if ( (Index < 1) || (Index > traceCount) )
    {
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Trace Index");
    }
    
    /* Get trace name */
    viCheckParm( Ivi_GetNthRepCapName(vi, "Trace",
                                      Index, &traceName), 2, "Index");
    
    actualSize = (ViInt32)strlen(traceName) + 1;
    
    /* Prepare return values */
    if (NameBufferSize == 0)
    {
        error = actualSize;
    }
    else 
    {
        if (NameBufferSize > 0)
        {
            if (actualSize > NameBufferSize)
            {
                error = actualSize;
                actualSize = NameBufferSize;
            }
        }
        memcpy(Name, traceName, actualSize-1);
        Name[actualSize-1] = '\0';
    }
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_Initiate
 * Purpose:   This function initiates an acquisition. After calling this function, 
 *            the spectrum analyzer leaves the idle state.
 *            
 *            This function does not check the instrument status. The user calls 
 *            the Acquisition Status function to determine when the acquisition 
 *            is complete. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_Initiate (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    if (!Ivi_Simulating(vi))                /* Call only when locked */
    {
        ViSession   io = Ivi_IOSession(vi); /* Call only when locked */
        
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE)); 
        
        viCheckErr( viPrintf (io, ":INIT;"));
    }
    
    /*
        Do not invoke the ssa3000x_CheckStatus function here. It
        is invoked by the high-level driver functions when this function is
        used internally. After the user calls this function, the end-
        user can check for errors by calling the ssa3000x_error_query
        function
    */

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_QueryTraceSize
 * Purpose:   This function queries the read-only Trace Size attribute. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_QueryTraceSize (ViSession vi, 
                                            ViConstString TraceName, 
                                            ViInt32* TraceSize)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString   activeTrace;
    
    checkErr( Ivi_CoerceRepCapName (vi, TRACE_REP_CAP_NAME, TraceName, &TraceName));     
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    
    viCheckParm( Ivi_SetAttributeViString(vi, VI_NULL, SSA3000X_ATTR_ACTIVE_TRACE, 
                 0, TraceName), 2, "Trace Name");
    
    checkErr( ssa3000x_GetActiveTrace(vi, &activeTrace, VI_FALSE));    
    viCheckParm( Ivi_GetAttributeViInt32 (vi, activeTrace, SSA3000X_ATTR_TRACE_SIZE,
                 0, TraceSize), 3, "Trace Size");                              

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ReadYTrace
 * Purpose:   This function initiates a signal acquisition based on the present 
 *            instrument configuration. It then waits for the acquisition to complete, 
 *            and returns the trace as an array of amplitude values. The amplitude 
 *            array returns data that represent the amplitude of the signals obtained
 *            by sweeping from the start frequency to the stop frequency (in frequency
 *            domain, in time domain the amplitude array is ordered from beginning of 
 *            sweep to end). The Amplitude Units attribute determines the units of the 
 *            points in the amplitude array. This function resets the sweep count.
 *            
 *            If the spectrum analyzer did not complete the acquisition within the time
 *            period the user specified with the MaxTime parameter, the function returns 
 *            the Max Time Exceeded error.
 *            
 *            After this function executes, each element in the amplitude array parameter 
 *            is either a amplitude or a value indicating that the spectrum analyzer could 
 *            not sample an amplitude. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ReadYTrace (ViSession vi, 
                                        ViConstString TraceName,
                                        ViInt32 MaxTimeMilliseconds,
                                        ViInt32 ArrayLength, 
                                        ViInt32* ActualPoints,
                                        ViReal64 Amplitude[])
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_Initiate (vi));
    error = ssa3000x_WaitForOPC (vi, MaxTimeMilliseconds);  

    if ( error == VI_ERROR_TMO)                   
        viCheckErr( IVISPECAN_ERROR_MAX_TIME_EXCEEDED);                                                        

    checkErr( ssa3000x_FetchYTrace (vi, TraceName, ArrayLength, ActualPoints, Amplitude));                            

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn ACPR Group Functions =============================*
 *===========================================================================*/         
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureACPR
 * Purpose:   This function configures the Adjacent Channel Power measurement. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureACPR (ViSession vi, 
                                           ViReal64 CenterFrequency, 
                                           ViReal64 MainIntergrationBandwidth)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_ACPR) || 
        (instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not ACPR");
    
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_ACPR_CENTER_FREQUENCY,
                 0, CenterFrequency), 2, "Center Frequency");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH,
                 0, MainIntergrationBandwidth), 3, "Main Intergration Bandwidth");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}           
            
                
/*******************************************************************************
 * Function:  ssa3000x_ReadMeasurementACPR
 * Purpose:   This function initiates a ACPR measurement acquisition based on the 
 *            present instrument configuration.  It then waits for the acquisition 
 *            to complete, and returns the ACPR measurement. 
 *            
 *            Note:
 *            
 *            If the spectrum analyzer did not complete the acquisition within the
 *            time period the user specified with the maxTime parameter, the function
 *            returns Max Time Exceeded error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ReadMeasurementACPR (ViSession vi, 
                                                 ViInt32 MaxTime, 
                                                 ViReal64* LowACP,
                                                 ViReal64* LowACPR, 
                                                 ViReal64* UpperACP, 
                                                 ViReal64* UpperACPR, 
                                                 ViReal64* MainChannelPower)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( ssa3000x_Initiate (vi));
    error = ssa3000x_WaitForOPC (vi, MaxTime);  

    if ( error == VI_ERROR_TMO)                   
        viCheckErr( IVISPECAN_ERROR_MAX_TIME_EXCEEDED);                                                        

    checkErr( ssa3000x_FetchMeasurementACPR (vi, LowACP, LowACPR, UpperACP, 
              UpperACPR, MainChannelPower));                            

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
} 
                
/*******************************************************************************
 * Function:  ssa3000x_FetchMeasurementACPR
 * Purpose:   This function returns the ACPR measurement the spectrum analyzer
 *            acquires. The measurement is from a previously initiated acquisition.  
 *            You use the ssa3000x_Initiate function to start an acquisition.  
 *            You use the ssa3000x_AcquisitionStatus function to determine when 
 *            the acquisition is complete.
 *            
 *            You can call the Read Measurement ACPR function instead of the 
 *            Initiate function. This function starts an acquisition, waits for 
 *            the acquisition to complete, and returns the measurement in one 
 *            function call.
 *            
 *            This function does not check the instrument status. Typically, 
 *            the end-user calls this function only in a sequence of calls to 
 *            other low-level driver functions. The sequence performs one operation. 
 *            The end-user uses the low-level functions to optimize one or more 
 *            aspects of interaction with the instrument. Call the 
 *            ssa3000x_error_query function at the conclusion of the sequence to 
 *            check the instrument status. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_FetchMeasurementACPR (ViSession vi, 
                                                  ViReal64* LowACP, 
                                                  ViReal64* LowACPR, 
                                                  ViReal64* UpperACP, 
                                                  ViReal64* UpperACPR, 
                                                  ViReal64* MainChannelPower)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (LowACP == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Low ACP");
    if (LowACPR == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Low ACPR");
    if (UpperACP == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 4, "Null address for Upper ACP");
    if (UpperACPR == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 5, "Null address for Upper ACPR");
    if (MainChannelPower == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 6, "Null address for Main Channel Power");

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) || 
        (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_ACPR))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not ACPR");

    if (!Ivi_Simulating (vi))               /* Call only when locked */
    {
        ViSession   io = Ivi_IOSession (vi); /* Call only when locked */

        viCheckErr( viQueryf (io, ":MEAS:ACPR:LOW:POW?;", "%Lg", LowACP)); 

        viCheckErr( viQueryf (io, ":MEAS:ACPR:LOW?;", "%Lg", LowACPR));

        viCheckErr( viQueryf (io, ":MEAS:ACPR:UPP:POW?;", "%Lg", UpperACP));

        viCheckErr( viQueryf (io, ":MEAS:ACPR:UPP?;", "%Lg", UpperACPR));

        viCheckErr( viQueryf (io, ":MEAS:ACPR:MAIN?;", "%Lg", MainChannelPower));
    }
    else
    {
        *LowACP = 0.0;
        *LowACPR = 0.5;
        *UpperACP = 0.0;
        *UpperACPR = 0.5;
        *MainChannelPower = -50;
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}                
            

/*===========================================================================*
 *= IviSpecAn CHP Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureCHP
 * Purpose:   This function configures the channel power settings. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureCHP (ViSession vi, 
                                          ViReal64 CenterFrequency, 
                                          ViReal64 IntegrationBandwidth, 
                                          ViReal64 ChannelSpan)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_CHP) ||
        (instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not CHP");
    
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CHP_CENTER_FREQUENCY,
                 0, CenterFrequency), 2, "Center Frequency");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH,
                 0, IntegrationBandwidth), 3, "Integration Bandwidth");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CHP_CHANNEL_SPAN,
                 0, ChannelSpan), 4, "Channel Span");
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}                 
            
                
/*******************************************************************************
 * Function:  ssa3000x_FetchMeasurementCHP
 * Purpose:   This function returns the CHP measurement the spectrum analyzer acquires. 
 *            The measurement is from a previously initiated acquisition.  You use the 
 *            ssa3000x_Initiate function to start an acquisition.  You use the 
 *            ssa3000x_AcquisitionStatus function to determine when the acquisition 
 *            is complete.
 *            
 *            You can call the Read Measurement CHP function instead of the Initiate 
 *            function. This function starts an acquisition, waits for the acquisition 
 *            to complete, and returns the measurement in one function call.
 *            
 *            This function does not check the instrument status. Typically, the end-user
 *            calls this function only in a sequence of calls to other low-level driver 
 *            functions. The sequence performs one operation. The end-user uses the 
 *            low-level functions to optimize one or more aspects of interaction with 
 *            the instrument. Call the ssa3000x_error_query function at the conclusion
 *            of the sequence to check the instrument status. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_FetchMeasurementCHP (ViSession vi, 
                                                 ViReal64* MainChannelPower, 
                                                 ViReal64* PowerDensity)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (MainChannelPower == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Main Channel Power");
    if (PowerDensity == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Power Density");
    
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) || 
        (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_CHP))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not CHP");

    if (!Ivi_Simulating (vi))               /* Call only when locked */
    {
        ViSession   io = Ivi_IOSession (vi); /* Call only when locked */

        viCheckErr( viQueryf (io, ":MEAS:CHP?;", "%Lg,%Lg", MainChannelPower, PowerDensity)); 
    }
    else
    {
        *PowerDensity = 1.0;
        *MainChannelPower = -50;
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}           
            
                
/*******************************************************************************
 * Function:  ssa3000x_ReadMeasurementCHP
 * Purpose:   This function initiates a CHP measurement acquisition based on the 
 *            present instrument configuration.  It then waits for the acquisition
 *            to complete, and returns the CHP measurement. 
 *            
 *            Note:
 *            
 *            If the spectrum analyzer did not complete the acquisition within the
 *            time period the user specified with the maxTime parameter, the function 
 *            returns Max Time Exceeded error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ReadMeasurementCHP (ViSession vi,
                                                ViInt32 MaxTime, 
                                                ViReal64* MainChannelPower,
                                                ViReal64* PowerDensity)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( ssa3000x_Initiate (vi));
    error = ssa3000x_WaitForOPC (vi, MaxTime);  

    if ( error == VI_ERROR_TMO)                   
        viCheckErr( IVISPECAN_ERROR_MAX_TIME_EXCEEDED);                                                        

    checkErr( ssa3000x_FetchMeasurementCHP (vi, MainChannelPower, PowerDensity));                            

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}                
            
 /*===========================================================================*
 *= IviSpecAn OBW Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureOBW
 * Purpose:   This function configures the OBW measurement method, OBW power percentage and the dBc value. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureOBW (ViSession vi, 
                                          ViInt32 OBWMethod, 
                                          ViReal64 OBWPowerPercentage, 
                                          ViReal64 OBWPowerLevel)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));
	printf("%d",3);    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_OBW) ||
        (instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not OBW");

    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_OBW_METHOD,
                 0, OBWMethod), 2, "OBW Method");
	printf("%d",4);    
    
    switch (OBWMethod)
    {
        case  SSA3000X_VAL_OBW_METHOD_PERCENT:
            viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_OBW_POWER_PERCENTAGE,
                         0, OBWPowerPercentage), 3, "OBW Power Percentage");
			printf("%d",1);
            break;
        case  SSA3000X_VAL_OBW_METHOD_DBC:
            viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_OBW_POWER_LEVEL,
                         0, OBWPowerLevel), 4, "OBW Power Level");
			printf("%d",2);    
            break;
    }  

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}


/*******************************************************************************
 * Function:  ssa3000x_FetchMeasurementOBW
 * Purpose:   This function returns the OBW measurement the spectrum analyzer acquires. 
 *            The measurement is from a previously initiated acquisition.  You use the 
 *            ssa3000x_Initiate function to start an acquisition.  You use the 
 *            ssa3000x_AcquisitionStatus function to determine when the acquisition
 *            is complete.
 *            
 *            You can call the Read Measurement BOW function instead of the Initiate 
 *            function. This function starts an acquisition, waits for the acquisition 
 *            to complete, and returns the measurement in one function call.
 *            
 *            This function does not check the instrument status. Typically, the 
 *            end-user calls this function only in a sequence of calls to other 
 *            low-level driver functions. The sequence performs one operation. The 
 *            end-user uses the low-level functions to optimize one or more aspects 
 *            of interaction with the instrument. Call the ssa3000x_error_query 
 *            function at the conclusion of the sequence to check the instrument status. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_FetchMeasurementOBW (ViSession vi, 
                                                 ViReal64* OccupiedBandwidth, 
                                                 ViReal64* BandwidthCentroid,  
                                                 ViReal64* XDbBandwidth)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     measurementType;
    ViInt32     instrumentMode;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if (OccupiedBandwidth == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for Occupied Bandwidth");
    if (XDbBandwidth == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "Null address for X Db Bandwidth");

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrumentMode));

    if ((instrumentMode != SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) || 
        (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_OBW))
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, "The measurement type is not OBW");

    if (!Ivi_Simulating (vi))               /* Call only when locked */
    {
        ViSession   io = Ivi_IOSession (vi); /* Call only when locked */

        viCheckErr( viQueryf (io, ":MEAS:OBW?;", "%Lg,%Lg", OccupiedBandwidth, BandwidthCentroid)); 

        viCheckErr( viQueryf (io, ":OBW:XDB?;", "%Lg", XDbBandwidth)); 
    }
    else
    {
        *OccupiedBandwidth = 200000.0;
        *BandwidthCentroid = 100000.0;
        *XDbBandwidth = 20.0;
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}            
            
                
/*******************************************************************************
 * Function:  ssa3000x_ReadMeasurementOBW
 * Purpose:   This function initiates a OBW measurement acquisition based on the 
 *            present instrument configuration.  It then waits for the acquisition
 *            to complete, and returns the OBW measurement. 
 *            
 *            Note:
 *            
 *            If the spectrum analyzer did not complete the acquisition within the 
 *            time period the user specified with the maxTime parameter, the function
*             returns Max Time Exceeded error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ReadMeasurementOBW (ViSession vi, 
                                                ViInt32 MaxTime, 
                                                ViReal64* OccupiedBandwidth,
                                                ViReal64* BandwidthCentroid, 
                                                ViReal64* XDbBandwidth)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( ssa3000x_Initiate (vi));
    error = ssa3000x_WaitForOPC (vi, MaxTime);  

    if ( error == VI_ERROR_TMO)                   
        viCheckErr( IVISPECAN_ERROR_MAX_TIME_EXCEEDED);                                                        

    checkErr( ssa3000x_FetchMeasurementOBW( vi, OccupiedBandwidth, BandwidthCentroid, XDbBandwidth));

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}  
/*===========================================================================*
 *= IviSpecAn IviSpecAnMultitrace Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_AddTraces
 * Purpose:   This function modifies a trace to be the point by point sum of two 
 *            other traces. Any data in the destination trace is deleted.
 *            
 *            DestinationTrace = Trace1 + Trace2 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_AddTraces (
                  ViSession vi, ViConstString DestinationTrace, ViConstString Trace1, 
                  ViConstString Trace2)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_CopyTrace
 * Purpose:   Copies the data array from one trace into another trace. Any data 
 *            in the Destination Trace is deleted. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_CopyTrace (ViSession vi, 
                                       ViConstString DestinationTrace, 
                                       ViConstString SourceTrace)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;                                    

Error:
    Ivi_UnlockSession(vi, VI_NULL);   
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ExchangeTraces
 * Purpose:   Exchanges the data arrays of two traces.
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ExchangeTraces (ViSession vi, 
                                            ViConstString Trace1, 
                                            ViConstString Trace2)
{
    ViStatus    error = VI_SUCCESS;
    checkErr( Ivi_LockSession (vi, VI_NULL));    
    
    error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;                                    

Error:
    Ivi_UnlockSession(vi, VI_NULL);   
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_SubtractTraces
 * Purpose:   This function modifies a trace to be the point by point difference
 *            between two traces. Any data in the destination trace is deleted.
 *            
 *            DestinationTrace = Trace1 - Trace2 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_SubtractTraces ( ViSession vi, 
                                             ViConstString DestinationTrace, 
                                             ViConstString Trace1, 
                                             ViConstString Trace2)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn IviSpecAnMarker Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureDemodulation
 * Purpose:   Configures marker demodulation settings. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureDemodulation (ViSession vi, 
                                                   ViInt32 DemodulationFunction,
                                                   ViReal64 SpeakerVolume, 
                                                   ViReal64 DelayTime)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION,
                 0, DemodulationFunction), 2, "Demodulation Function");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME,
                 0, SpeakerVolume), 3, "Speaker Volume");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME,
                 0, DelayTime), 4, "Delay Time");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMarkerPeakSearch
 * Purpose:   Configures peak search settings. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerPeakSearch (ViSession vi, 
                                                       ViBoolean MarkerContinuousPeakingEnable, 
                                                       ViInt32 PeakSearchMode)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker;  
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));  
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, activeMarker, SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE,
                 0, MarkerContinuousPeakingEnable), 2, "Marker Continuous Peaking Enable");
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_PEAK_SEARCH_TYPE,
                 0, PeakSearchMode), 3, "Peak Search Mode");
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMarkerEnabled
 * Purpose:   This function enables the active marker on the specified Trace. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerEnabled (ViSession vi, 
                                                    ViBoolean MarkerEnabled, 
                                                    ViConstString MarkerTraceName)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));  
    
    viCheckParm( Ivi_SetAttributeViBoolean (vi, activeMarker, SSA3000X_ATTR_MARKER_ENABLED,
                 0, MarkerEnabled), 2, "Marker Enabled");
    
    if (MarkerEnabled) 
    {
        viCheckParm( Ivi_SetAttributeViString (vi, activeMarker, SSA3000X_ATTR_MARKER_TRACE,
                     0, MarkerTraceName), 3, "Marker Trace Name");                              
    }
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMarkerFrequencyCounter
 * Purpose:   This function sets the marker frequency counter resolution and enables
 *            or disables the marker frequency counter. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerFrequencyCounter (ViSession vi,
                                                             ViBoolean Enabled,
                                                             ViReal64 Resolution)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));  
	if(Enabled)
	{ 
		viCheckParm( Ivi_SetAttributeViBoolean (vi, activeMarker, SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED, 0, Enabled), 2, "Enabled");
	}
	else
	{
		if (!Ivi_Simulating (vi))
		{
			ViSession   io = Ivi_IOSession (vi);   
			viCheckErr( viPrintf (io, ":CALCulate:%s:FUNCtion  OFF",activeMarker));
		}
	}
 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMarkerSearch
 * Purpose:   This function configures the Peak Excursion and Marker Threshold attribute values. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerSearch (ViSession vi, 
                                                   ViReal64 PeakExcursion, 
                                                   ViReal64 MarkerThreshold)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
    
    viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_PEAK_EXCURSION,
                 0, PeakExcursion), 2, "Peak Excursion");
    viCheckParm( Ivi_SetAttributeViReal64 (vi, activeMarker, SSA3000X_ATTR_MARKER_THRESHOLD,
                 0, MarkerThreshold), 3, "Marker Threshold");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureSignalTrackEnabled
 * Purpose:   If set to True , the active marker is enabled. When False, the active 
 *            marker is disabled. 
 *
 *            Note:
 *            This function is not supported.
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureSignalTrackEnabled (ViSession vi, 
                                                         ViBoolean SignalTrackEnabled)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    error = IVI_ERROR_FUNCTION_NOT_SUPPORTED;

Error:
    Ivi_UnlockSession(vi, VI_NULL);   
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_DisableAllMarkers
 * Purpose:   This function disables all markers. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_DisableAllMarkers (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    if (!Ivi_Simulating(vi))                
    {
        ViSession   io = Ivi_IOSession(vi); /* call only when locked */

        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));
        viCheckErr( viPrintf (io, ":CALC:MARK:AOFF"));
    }
    
    {
        ViChar  marker_list[256] = MARKER_LIST;
        ViChar* marker_name;
    
        marker_name = strtok (marker_list, ",");
        while (marker_name)
        {
            checkErr(Ivi_SetAttributeViBoolean( vi,
                                                marker_name,
                                                SSA3000X_ATTR_MARKER_ENABLED,
                                                IVI_VAL_SET_CACHE_ONLY | IVI_VAL_DONT_MARK_AS_SET_BY_USER,
                                                VI_FALSE));

            marker_name = strtok (NULL, ",");
        }
    }
    checkErr( Ivi_SetAttributeViString( vi, VI_NULL, SSA3000X_ATTR_ACTIVE_MARKER,
                                        IVI_VAL_SET_CACHE_ONLY | IVI_VAL_DONT_MARK_AS_SET_BY_USER,
                                        DEFAULT_ACTIVE_MARKER));

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_GetMarkerName
 * Purpose:   This function returns the specific driver defined marker name that 
 *            corresponds to the one-based index that the user specifies. If the 
 *            driver defines a qualified marker name, this function returns the 
 *            qualified name. If the value that the user passes for the Index 
 *            parameter is less then one or greater than the value of the Marker
 *            Count attribute, the function returns an empty string in the Name 
 *            parameter and returns the Invalid Value error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_GetMarkerName (ViSession vi, 
                                           ViInt32 Index, 
                                           ViInt32 NameBufferSize, 
                                           ViChar Name[])
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   marker_name;
    ViInt32         length;

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( Ivi_GetNthRepCapName (vi, MARKER_REP_CAP_NAME,
                                    Index, &marker_name));

    if ( marker_name == NULL )
        viCheckParm( IVI_ERROR_INVALID_VALUE, 2, "index");

    if (NameBufferSize > 0 && Name != VI_NULL)
    {
        strncpy(Name, marker_name, NameBufferSize);
    }
    
    length = (marker_name) ? (ViInt32)strlen(marker_name) : 0;
    
    if ((length + 1) > NameBufferSize)
        error = length+1;

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_MarkerSearch
 * Purpose:   This function specifies the type of marker search and performs the 
 *            search. This function returns the Marker Not Enabled error if the 
 *            Marker Enabled attribute is set to False. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_MarkerSearch (ViSession vi,
                                          ViInt32 SearchType)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, activeMarker, SSA3000X_ATTR_MARKER_PEAK_SEARCH,
                 0, SearchType), 2, "Search Type");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_MoveMarker
 * Purpose:   This function specifies the frequency in Hertz or time position in 
 *            seconds of the specified horizontal position. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_MoveMarker (ViSession vi, 
                                        ViReal64 MarkerPosition)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker;  
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE)); 
    
    viCheckParm( Ivi_SetAttributeViReal64 (vi, activeMarker, SSA3000X_ATTR_MARKER_POSITION,
                 0, MarkerPosition), 2, "Marker Position");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_QueryMarker
 * Purpose:   This function returns the horizontal position and the amplitude level 
 *            of the active marker. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_QueryMarker (ViSession vi, 
                                         ViReal64* MarkerPosition, 
                                         ViReal64* MarkerAmplitude)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString   activeMarker; 
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
    
    viCheckParm( Ivi_GetAttributeViReal64 (vi, activeMarker, SSA3000X_ATTR_MARKER_POSITION,
                 0, MarkerPosition), 2, "Marker Position");
    viCheckParm( Ivi_GetAttributeViReal64 (vi, activeMarker, SSA3000X_ATTR_MARKER_AMPLITUDE,
                 0, MarkerAmplitude), 3, "Marker Amplitude");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_SetActiveMarker
 * Purpose:   This function selects one of the available markers, and makes it the
 *            active marker. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_SetActiveMarker (ViSession vi, 
                                             ViConstString ActiveMarker)
{
    return Ivi_SetAttributeViString (vi, VI_NULL, SSA3000X_ATTR_ACTIVE_MARKER,
                                     IVI_VAL_DIRECT_USER_CALL, ActiveMarker);
}
                
/*******************************************************************************
 * Function:  ssa3000x_SetInstrumentFromMarker
 * Purpose:   This function uses the Marker Position or Marker Amplitude attributes
 *            to configure the spectrum analyzer setting specified by the 
 *            InstrumentSetting parameter.
 *            
 *            This function may set the Frequency Start, Frequency Stop, or Reference
 *            Level attributes.
 *            If the Marker Enabled attribute is set to False, this function returns
 *            the Marker Not Enabled error. If the Marker Type attribute is not Delta
 *            and the InstrumentSetting parameter is Frequency Span, the function
 *            returns the Delta Marker Not Enabled error. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_SetInstrumentFromMarker (ViSession vi, 
                                                     ViInt32 InstrumentSetting)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        instrMode = 0;
    ViInt32        measurementType = 0;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {       
        /*
         * Get Active marker and test if the marker is enabled.
         */
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

        viCheckParm( Ivi_SetAttributeViInt32 (vi, activeMarker, SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING,
                     0, InstrumentSetting), 2, "Instrument Setting");                              

        checkErr( ssa3000x_CheckStatus (vi));
    }
    else
    {
        viCheckErrElab ( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current instrument mode or measurement type.");
    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn IviSpecAnTrigger Group Functions =============================*
 *===========================================================================*/         
            
/*******************************************************************************
 * Function:  ssa3000x_ConfigureTriggerSource
 * Purpose:   This function specifies the trigger source that causes the spectrum 
 *            analyzer to leave the Wait-for-Trigger state. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureTriggerSource (ViSession vi, 
                                                    ViInt32 TriggerSource)
{
    ViStatus    error = VI_SUCCESS;
    
    checkErr( Ivi_LockSession (vi, VI_NULL)); 
    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_TRIGGER_SOURCE,
                 0, TriggerSource), 2, "Trigger Source");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn IviSpecAnExternalTrigger Group Functions ======================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureExternalTrigger
 * Purpose:   This function specifies at which level and slope of the external 
 *            trigger signal, acquisition is triggered. This is applicable when 
 *            the Trigger Source attribute is set to External. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureExternalTrigger (ViSession vi,
                                                      ViReal64 ExternalTriggerLevel,
                                                      ViInt32 ExternalTriggerSlope)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     trigger_source = 0;
    ViReal64    frequency_span = 0;
    ViInt32     result = -1;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( Ivi_GetAttributeViInt32( vi, VI_NULL, SSA3000X_ATTR_TRIGGER_SOURCE, 0, &trigger_source));
    checkErr( Ivi_GetAttributeViReal64( vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_SPAN, 0, &frequency_span));
    viCheckErr( Ivi_CompareWithPrecision(6, frequency_span, 0.0, &result)); 

    if ( result && trigger_source == SSA3000X_VAL_TRIGGER_SOURCE_EXTERNAL )
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_EXTERNAL_TRIGGER_LEVEL,
                     0, ExternalTriggerLevel), 2, "External Trigger Level");

        viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE,
                     0, ExternalTriggerSlope), 3, "External Trigger Slope");                              
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, 
            "The external trigger source must be selected AND configure the analyzer in zero span.");
    }

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn IviSpecAnVideoTrigger Group Functions =========================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureVideoTrigger
 * Purpose:   This function specifies at which level and slope of the video signal, 
 *            acquisition is triggered. This is applicable when the Trigger Source
 *            attribute is set to Video. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureVideoTrigger (ViSession vi, 
                                                   ViReal64 VideoTriggerLevel,
                                                   ViInt32 VideoTriggerSlope)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     trigger_source = 0;
    ViReal64    frequency_span = 0;
    ViInt32     result = VI_FALSE;
    
    checkErr( Ivi_LockSession (vi, VI_NULL));

    checkErr( Ivi_GetAttributeViInt32( vi, VI_NULL, SSA3000X_ATTR_TRIGGER_SOURCE, 0, &trigger_source));
    checkErr( Ivi_GetAttributeViReal64( vi, VI_NULL, SSA3000X_ATTR_FREQUENCY_SPAN, 0, &frequency_span));
    viCheckErr( Ivi_CompareWithPrecision(0, frequency_span, 0.0, &result)); 

    if ( result && trigger_source == SSA3000X_VAL_TRIGGER_SOURCE_VIDEO )
    {
        viCheckParm( Ivi_SetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL,
                     0, VideoTriggerLevel), 2, "Video Trigger Level");
        viCheckParm( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_VIDEO_TRIGGER_SLOPE,
                     0, VideoTriggerSlope), 3, "Video Trigger Slope");                           
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_CONFIGURATION, 
            "The external trigger source must be selected AND configure the analyzer in zero span.");
    }

    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*===========================================================================*
 *= IviSpecAn IviSpecAnMarkerType Group Functions =============================*
 *===========================================================================*/         
            
                
/*******************************************************************************
 * Function:  ssa3000x_ConfigureMarkerType
 * Purpose:   This function selects the type of markers that you want to activate.
 *            
 *            Notes:
 *            The user must call ssa3000x_SetActiveMarker function ahead to specify 
 *            the active marker before calling this function. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_ConfigureMarkerType (ViSession vi, 
                                                 ViInt32 MarkerType, 
                                                 ViInt32 MarkerFunction)
{
    ViStatus    error = VI_SUCCESS;
    ViConstString  activeMarker;  
    
    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE)); 
    
    viCheckParm( Ivi_SetAttributeViInt32 (vi, activeMarker, SSA3000X_ATTR_MARKER_TYPE,
                 0, MarkerType), 2, "Marker Type");
    viCheckParm( Ivi_SetAttributeViInt32 (vi, activeMarker, SSA3000X_ATTR_MARKER_FUNCTION,
                 0, MarkerFunction), 3, "Marker Function");                              
                 
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            
                
/*******************************************************************************
 * Function:  ssa3000x_QueryMarkerType
 * Purpose:   This function returns the type of the active marker. 
*******************************************************************************/            
ViStatus _VI_FUNC ssa3000x_QueryMarkerType (ViSession vi,
                                             ViInt32* MarkerType)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        instrMode = 0;
    ViInt32        measurementType = 0;
    ViConstString   activeMarker;

    checkErr( Ivi_LockSession (vi, VI_NULL));
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {       
        viCheckParm( Ivi_GetAttributeViInt32 (vi, activeMarker, SSA3000X_ATTR_MARKER_TYPE,
                     0, MarkerType), 2, "Marker Type");                              

        checkErr( ssa3000x_CheckStatus (vi));
    }
    else
    {
        viCheckErrElab ( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current instrument mode or measurement type.");

    }

Error:
    Ivi_UnlockSession(vi, VI_NULL);
    return error;
}               
            

/*****************************************************************************
 * Function: ssa3000x_GetAttribute<type> Functions                                    
 * Purpose:  These functions enable the instrument driver user to get 
 *           attribute values directly.  There are typesafe versions for 
 *           ViInt32, ViReal64, ViString, ViBoolean, and ViSession attributes.                                         
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_GetAttributeViInt32 (ViSession vi, ViConstString channelName, 
                                                ViAttr attributeId, ViInt32 *value)
{                                                                                                           
    return Ivi_GetAttributeViInt32 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                    value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_GetAttributeViReal64 (ViSession vi, ViConstString channelName, 
                                                 ViAttr attributeId, ViReal64 *value)
{                                                                                                           
    return Ivi_GetAttributeViReal64 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                     value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_GetAttributeViString (ViSession vi, ViConstString channelName, 
                                                 ViAttr attributeId, ViInt32 bufSize, 
                                                 ViChar value[]) 
{   
    return Ivi_GetAttributeViString (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                     bufSize, value);
}   
ViStatus _VI_FUNC ssa3000x_GetAttributeViBoolean (ViSession vi, ViConstString channelName, 
                                                  ViAttr attributeId, ViBoolean *value)
{                                                                                                           
    return Ivi_GetAttributeViBoolean (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                      value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_GetAttributeViSession (ViSession vi, ViConstString channelName, 
                                                  ViAttr attributeId, ViSession *value)
{                                                                                                           
    return Ivi_GetAttributeViSession (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                      value);
}                                                                                                           

/*****************************************************************************
 * Function: ssa3000x_SetAttribute<type> Functions                                    
 * Purpose:  These functions enable the instrument driver user to set 
 *           attribute values directly.  There are typesafe versions for 
 *           ViInt32, ViReal64, ViString, ViBoolean, and ViSession datatypes.                                         
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_SetAttributeViInt32 (ViSession vi, ViConstString channelName, 
                                                ViAttr attributeId, ViInt32 value)
{                                                                                                           
    return Ivi_SetAttributeViInt32 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                    value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_SetAttributeViReal64 (ViSession vi, ViConstString channelName, 
                                                 ViAttr attributeId, ViReal64 value)
{                                                                                                           
    return Ivi_SetAttributeViReal64 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                     value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_SetAttributeViString (ViSession vi, ViConstString channelName, 
                                                 ViAttr attributeId, ViConstString value) 
{   
    return Ivi_SetAttributeViString (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                     value);
}   
ViStatus _VI_FUNC ssa3000x_SetAttributeViBoolean (ViSession vi, ViConstString channelName, 
                                                  ViAttr attributeId, ViBoolean value)
{                                                                                                           
    return Ivi_SetAttributeViBoolean (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                      value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_SetAttributeViSession (ViSession vi, ViConstString channelName, 
                                                  ViAttr attributeId, ViSession value)
{                                                                                                           
    return Ivi_SetAttributeViSession (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                      value);
}                                                                                                           

/*****************************************************************************
 * Function: ssa3000x_CheckAttribute<type> Functions                                  
 * Purpose:  These functions enable the instrument driver user to check  
 *           attribute values directly.  These functions check the value you
 *           specify even if you set the SSA3000X_ATTR_RANGE_CHECK 
 *           attribute to VI_FALSE.  There are typesafe versions for ViInt32, 
 *           ViReal64, ViString, ViBoolean, and ViSession datatypes.                         
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_CheckAttributeViInt32 (ViSession vi, ViConstString channelName, 
                                                  ViAttr attributeId, ViInt32 value)
{                                                                                                           
    return Ivi_CheckAttributeViInt32 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                      value);
}
ViStatus _VI_FUNC ssa3000x_CheckAttributeViReal64 (ViSession vi, ViConstString channelName, 
                                                   ViAttr attributeId, ViReal64 value)
{                                                                                                           
    return Ivi_CheckAttributeViReal64 (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                       value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_CheckAttributeViString (ViSession vi, ViConstString channelName, 
                                                   ViAttr attributeId, ViConstString value)  
{   
    return Ivi_CheckAttributeViString (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                       value);
}   
ViStatus _VI_FUNC ssa3000x_CheckAttributeViBoolean (ViSession vi, ViConstString channelName, 
                                                    ViAttr attributeId, ViBoolean value)
{                                                                                                           
    return Ivi_CheckAttributeViBoolean (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                        value);
}                                                                                                           
ViStatus _VI_FUNC ssa3000x_CheckAttributeViSession (ViSession vi, ViConstString channelName, 
                                                    ViAttr attributeId, ViSession value)
{                                                                                                           
    return Ivi_CheckAttributeViSession (vi, channelName, attributeId, IVI_VAL_DIRECT_USER_CALL, 
                                        value);
}                                                                                                           

/*****************************************************************************
 * Function: WriteInstrData and ReadInstrData Functions                      
 * Purpose:  These functions enable the instrument driver user to  
 *           write and read commands directly to and from the instrument.            
 *                                                                           
 *           Note:  
*            These functions bypass the IVI attribute state caching.  
 *           WriteInstrData invalidates the cached values for all attributes.
 *****************************************************************************/
ViStatus _VI_FUNC ssa3000x_WriteInstrData (ViSession vi, ViConstString writeBuffer)   
{   
    return Ivi_WriteInstrData (vi, writeBuffer);    
}   
ViStatus _VI_FUNC ssa3000x_ReadInstrData (ViSession vi, ViInt32 numBytes, 
                                          ViChar rdBuf[], ViInt32 *bytesRead)  
{   
    return Ivi_ReadInstrData (vi, numBytes, rdBuf, bytesRead);   
}           
    
/*****************************************************************************
 *-------------------- Utility Functions (Not Exported) ---------------------*
 *****************************************************************************/
 


/*****************************************************************************
 * Function: ssa3000x_IviInit                                                       
 * Purpose:  This function is called by ssa3000x_InitWithOptions  
 *           or by an IVI class driver.  This function initializes the I/O 
 *           interface, optionally resets the device, optionally performs an
 *           ID query, and sends a default setup to the instrument.   
 * Modification History:
 *           Orginal released by Chao Wang. 15/06/2012
 *           Modified by Chao Wang. 18/07/2013. Fix car 359275. 
 *****************************************************************************/
static ViStatus ssa3000x_IviInit (ViRsrc resourceName, ViBoolean IDQuery,
                                    ViBoolean reset, ViSession vi)
{
    ViStatus    error = VI_SUCCESS;
    ViSession   io = VI_NULL;
    ViInt32     instModel = SSA3000X_VAL_MODEL_SSA3000X;
    ViChar      modelStr[128] = "";
    
    checkErr( Ivi_BuildChannelTable (vi, CHANNEL_LIST, VI_FALSE, VI_NULL));
    checkErr( Ivi_BuildRepCapTable (vi, MARKER_REP_CAP_NAME, MARKER_LIST));
    
    checkErr( Ivi_BuildRepCapTable (vi, TRACE_REP_CAP_NAME, TRACE_LIST));
    
    
    if (!Ivi_Simulating(vi))
    {
        ViSession   rmSession = VI_NULL;
        /* Open instrument session */
        checkErr( Ivi_GetAttributeViSession (vi, VI_NULL, IVI_ATTR_VISA_RM_SESSION, 0,
                                             &rmSession)); 
        viCheckErr( viOpen (rmSession, resourceName, VI_NULL, VI_NULL, &io));
        /* io session owned by driver now */
        checkErr( Ivi_SetAttributeViSession (vi, VI_NULL, IVI_ATTR_IO_SESSION, 0, io));  

        /* Configure VISA Formatted I/O */
        viCheckErr( viSetAttribute (io, VI_ATTR_TMO_VALUE, 5000 ));
        viCheckErr( viSetBuf (io, VI_READ_BUF | VI_WRITE_BUF, 4000));
        viCheckErr( viSetAttribute (io, VI_ATTR_WR_BUF_OPER_MODE, VI_FLUSH_ON_ACCESS));
        viCheckErr( viSetAttribute (io, VI_ATTR_RD_BUF_OPER_MODE, VI_FLUSH_ON_ACCESS));
        
        /*- Identification Query ------------------------------------------------*/
        if (IDQuery)                               
        {
            ViChar rdBuffer[BUFFER_SIZE];

            ViChar *queryResponseA1 = "Siglent Technologies,SSA3032X";
			ViChar *queryResponseA2 = "Siglent Technologies,SSA3021X"; 
			ViChar *queryResponseA3 = "Siglent Technologies,SSA3010X"; 
			ViChar *queryResponseA4 = "Siglent Technologies,SSA3032X"; 
			ViChar *queryResponseA5 = "Siglent,SSA30"; 
			ViChar *queryResponseA6 = "SiglentXE,SSA30";
        
            viCheckErr( viQueryf (io, "*IDN?", "%256[^\n]", rdBuffer));
        
            if (strncmp (rdBuffer, queryResponseA1, strlen(queryResponseA1)) == 0 ||
				strncmp (rdBuffer, queryResponseA2, strlen(queryResponseA2)) == 0||
				strncmp (rdBuffer, queryResponseA3, strlen(queryResponseA3)) == 0||
				strncmp (rdBuffer, queryResponseA4, strlen(queryResponseA4)) == 0||
				strncmp (rdBuffer, queryResponseA5, strlen(queryResponseA5)) == 0||
				strncmp (rdBuffer, queryResponseA6, strlen(queryResponseA6)) == 0)
			{
                instModel = SSA3000X_VAL_MODEL_SSA3000X;  
			}
            else
			{
                viCheckErr( VI_ERROR_FAIL_ID_QUERY);
			}
        }
    }
    
    /*- Simulation or IDQuery == VI_FALSE ---------------------------------------*/
    if( (Ivi_Simulating(vi)) || (!IDQuery) )
    {
        checkErr( ssa3000x_GetDriverSetupOption (vi, "Model", 128, modelStr));

        if ((strlen(modelStr) != 0))
        {
            if(( strncmp (modelStr, "SSA3000X", strlen("SSA3000X")) == 0))
                instModel = SSA3000X_VAL_MODEL_SSA3000X;
            else
                viCheckErrElab( IVI_ERROR_INVALID_VALUE, "The model specified is not valid");
        }
    }

     /* Add attributes */
    checkErr( ssa3000x_InitAttributes (vi, instModel));
        
    /*- Reset instrument ----------------------------------------------------*/
    if (reset)
	{
        checkErr( ssa3000x_reset (vi));
	}
    else  /*- Send Default Instrument Setup ---------------------------------*/
	{
        checkErr( ssa3000x_DefaultInstrSetup (vi));
	}
    
    checkErr( ssa3000x_CheckStatus (vi));

Error:
    if (error < VI_SUCCESS)
    {
        if (!Ivi_Simulating (vi) && io)
		{
            viClose (io);
		}
    }
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_IviClose                                                        
 * Purpose:  This function performs all of the drivers clean-up operations   
 *           except for closing the IVI session.  This function is called by 
 *           ssa3000x_close or by an IVI class driver. 
 *
 *           Note:  
 *           This function must close the I/O session and set IVI_ATTR_IO_SESSION to 0.
 *****************************************************************************/
static ViStatus ssa3000x_IviClose (ViSession vi)
{
    ViStatus error = VI_SUCCESS;
    ViSession io = VI_NULL;

        /* Do not lock here.  The caller manages the lock. */

    checkErr( Ivi_GetAttributeViSession (vi, VI_NULL, IVI_ATTR_IO_SESSION, 0, &io));

Error:
    Ivi_SetAttributeViSession (vi, VI_NULL, IVI_ATTR_IO_SESSION, 0, VI_NULL);
    if(io)                                                      
    {
        viClose (io);
    }
    return error;   
}

/*****************************************************************************
 * Function: ssa3000x_CheckStatus                                                 
 * Purpose:  This function checks the status of the instrument to detect 
 *           whether the instrument has encountered an error.  This function  
 *           is called at the end of most exported driver functions.  If the    
 *           instrument reports an error, this function returns      
 *           IVI_ERROR_INSTRUMENT_SPECIFIC.  The user can set the 
 *           ssa3000x_ATTR_QUERY_INSTRUMENT_STATUS attribute to VI_FALSE to 
 *           disable this check and increase execution speed.                                   
 *
 *           Note:  Call this function only when the session is locked.
 *****************************************************************************/
static ViStatus ssa3000x_CheckStatus (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;

    if (Ivi_QueryInstrStatus (vi) && Ivi_NeedToCheckStatus (vi) && !Ivi_Simulating (vi))
    {
        checkErr( ssa3000x_CheckStatusCallback (vi, Ivi_IOSession(vi)));
        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_FALSE));
    }
        
Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_WaitForOPC                                                  
 * Purpose:  This function waits for the instrument to complete the      
 *           execution of all pending operations. It can be called from 
 *           other instrument driver functions. 
 *
 *           The maxTime parameter specifies the maximum time to wait for
 *           operation complete in milliseconds.
 *
 *           Note:  Call this function only when the session is locked.
 *****************************************************************************/
static ViStatus ssa3000x_WaitForOPC (ViSession vi, ViInt32 maxTime) 
{
    ViStatus    error = VI_SUCCESS;

    if (!Ivi_Simulating(vi))
    {
        ViInt32     oldOPCTimeout; 
        ViInt32     oldVisaTimeout;
        ViBoolean   opcDone = VI_FALSE;   
        ViSession   io = Ivi_IOSession(vi);
        
        viCheckErr( viGetAttribute (io, VI_ATTR_TMO_VALUE, &oldVisaTimeout));
        viCheckErr( viSetAttribute (io, VI_ATTR_TMO_VALUE, maxTime));

        checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_OPC_TIMEOUT, 0, &oldOPCTimeout));
        checkErr( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_OPC_TIMEOUT, 0, maxTime)); 

        //viCheckErr( viQueryf (io, "*OPC?", "%hd", &opcDone));
        
        checkErr( Ivi_SetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_OPC_TIMEOUT, 0, oldOPCTimeout));
        viCheckErr( viSetAttribute(io, VI_ATTR_TMO_VALUE, oldVisaTimeout));

        viCheckErr( error);
    }
Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_DefaultInstrSetup                                               
 * Purpose:  This function sends a default setup to the instrument.  The    
 *           ssa3000x_reset function calls this function.  The 
 *           ssa3000x_IviInit function calls this function when the
 *           user passes VI_FALSE for the reset parameter.  This function is 
 *           useful for configuring settings that other instrument driver 
 *           functions require.    
 *
 *           Note:  Call this function only when the session is locked.
 *****************************************************************************/
static ViStatus ssa3000x_DefaultInstrSetup (ViSession vi)
{
    ViStatus    error = VI_SUCCESS;
        
    /* Invalidate all attributes */
    checkErr( Ivi_InvalidateAllAttributes (vi));
    
    if (!Ivi_Simulating(vi))
    {
        ViSession   io = Ivi_IOSession(vi); /* call only when locked */

        checkErr( Ivi_SetNeedToCheckStatus (vi, VI_TRUE));
        
        /*
           *CLS     clears the event/status registers                                      
           *ESE 1   sets the standard event status enable register to recognize  
                    operation complete.                                          
           *SRE 32  sets the service request register to enable a service        
                    request on operation complete                                
           */                            
        
        viCheckErr( viPrintf (io, "*CLS;*ESE 1;*SRE 32"));
    }
Error:
    return error;
}

/*****************************************************************************
 *  Function: ssa3000x_GetDriverSetupOption
 *  Purpose:  Get the value of a DriverSetup option.  The driver setup string
 *            is part of the option string the user passes to the
 *            ssa3000x_InitWithOptions function.  Specifically it is the part
 *            that follows "DriverSetup=".  This function assumes the 
 *            DriverSetup string has the following format:
 *              "OptionTag1 : OptionValue1; OptionTag2 : OptionValue2"
 *            Leading and trailing white space is removed from the option
 *            value and both the option tag and option value may contain
 *            white space.  The option tag is case sensitive.
 *
 *            Example:
 *
 *              "DriverSetup= Model : InstrX ; Special Option:Feature Y "
 *
 *              optionTag "Model"          returns optionValue "InstrX"
 *
 *              optionTag "Special Option" returns optionValue "Feature Y"
 *****************************************************************************/
static ViStatus ssa3000x_GetDriverSetupOption (ViSession vi,
                                               ViConstString optionTag,
                                               ViInt32 optionValueSize,
                                               ViChar optionValue[])
{
    ViStatus error = VI_SUCCESS;
    ViChar   setup[BUFFER_SIZE];
    ViChar*  searchOrigin;
    ViChar*  start;
    ViChar*  end;
    ViUInt32 n;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    if ((optionValue != VI_NULL) && (optionValueSize > 0))
        optionValue[0] = 0;

    if ((optionTag != VI_NULL) && (optionValue != VI_NULL) && (optionValueSize > 1))
    {
        checkErr( Ivi_GetAttributeViString (vi, "", SSA3000X_ATTR_DRIVER_SETUP,
                                            0, BUFFER_SIZE, setup));
        searchOrigin = setup;
        while (searchOrigin != VI_NULL)
        {
            searchOrigin = strstr(searchOrigin, optionTag);
            if (searchOrigin)
            {
                searchOrigin += strlen(optionTag);
                start = searchOrigin;
                while (isspace(*start)) start++;
                if (*start == ':')
                {
                    start++;
                    while (isspace(*start)) start++;
                    if (*start)
                    {
                        end = strchr (start, ';');
                        if (start != end)
                        {
                            end = (end) ? end-1 : &setup[strlen(setup)-1];
                            while (isspace(*end)) end--;
                            n = (ViUInt32) (end - start + 1);
                            if (n > optionValueSize - 1)
                                n = optionValueSize - 1;
                            strncpy(optionValue, start, n);
                            optionValue[n] = 0;
                            break;
                        }
                    }
                }
            }
        }
    }
        
Error:
    Ivi_UnlockSession (vi, VI_NULL);
    return error;
}

/*****************************************************************************
 *  Function: ssa3000x_GetStringFromTable
 *  Purpose:  Read the string command from rangetable    
 *****************************************************************************/
static ViStatus ssa3000x_GetStringFromTable(
        ssa3000xStringValueTable table,
    ViInt32               value,
    ViConstString*        string
)
{
    ViStatus    error = VI_SUCCESS;
    ViBoolean   found = VI_FALSE;
    ViInt32     i;
    
    for( i = 0; table[i].string; i++)
    {
        if ( table[i].value == value )
        {
            *string = table[i].string;
            found = VI_TRUE;
            break;
        }
    }
    
    if ( !found )
        error = IVI_ERROR_INVALID_VALUE;

    return error;
}

/*****************************************************************************
 *  Function: ssa3000x_GetRepCommandFromTable
 *  Purpose:  Read the repeated command from range table to connect with the 
 *            string command.
 *****************************************************************************/
static ViStatus ssa3000x_GetRepCommandFromTable(
    ssa3000xStringValueTable table,
    ViInt32               value,
    ViConstString*        repCommand
)
{
    ViStatus    error = VI_SUCCESS;
    ViBoolean   found = VI_FALSE;
    ViInt32     i;

    for( i = 0; table[i].repCommand; i++)
    {
        if ( table[i].value == value )
        {
            *repCommand = table[i].repCommand;
            found = VI_TRUE;
            break;
        }
    }

    if ( !found )
        error = IVI_ERROR_INVALID_VALUE;

    return error;
}


/*****************************************************************************
 *------------------------ Global Session Callbacks -------------------------*
 *****************************************************************************/

/*****************************************************************************
 * Function: ssa3000x_CheckStatusCallback                                               
 * Purpose:  This function queries the instrument to determine if it has 
 *           encountered an error.  If the instrument has encountered an 
 *           error, this function returns the IVI_ERROR_INSTRUMENT_SPECIFIC 
 *           error code.  This function is called by the 
 *           ssa3000x_CheckStatus utility function.  The 
 *           Ivi_SetAttribute and Ivi_GetAttribute functions invoke this 
 *           function when the optionFlags parameter includes the
 *           IVI_VAL_DIRECT_USER_CALL flag.
 *           
 *           The user can disable calls to this function by setting the 
 *           SSA3000X_QUERY_INSTRUMENT_STATUS attribute to VI_FALSE.  The driver can 
 *           disable the check status callback for a particular attribute by 
 *           setting the IVI_VAL_DONT_CHECK_STATUS flag.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000x_CheckStatusCallback (ViSession vi, ViSession io)
{
    ViStatus    error = VI_SUCCESS;
    
    ViInt16     esr = 0; 
    
    viCheckErr( viQueryf (io, "*ESR?", "%hd", &esr));
    if (esr & IEEE_488_2_ERROR_MASK)
    {
        viCheckErr( IVI_ERROR_INSTR_SPECIFIC);
    }

Error:
    return error;
}

static ViStatus _VI_FUNC ssa3000xEnum_WriteCallback (ViSession vi, ViSession io,
                                                     ViConstString channelName,
                                                     ViAttr attributeId,
                                                     ViInt32 value)
{
    ViStatus            error = VI_SUCCESS;
    ViString            command,
                        commandValue;
    ViString            repCommand;                     
    IviRangeTablePtr    table;

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xEnum_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xEnum_commands, attributeId, &repCommand));

    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table));
    viCheckErr( ssa3000x_GetCmdFromIntValue(value, table, &commandValue));
    
    if (!Ivi_Simulating (vi))
    {
        viCheckErr( viPrintf (io, "%s%s%s %s", command, VALID_CHANNELNAME (channelName), repCommand, commandValue));
    }
Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xEnum_ReadCallback                                               
 * Purpose:  This function reads the enum value of the ViInt32 attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xEnum_ReadCallback (ViSession      vi, 
                                                     ViSession      io, 
                                                     ViConstString  channelName,   
                                                     ViAttr         attributeId,  
                                                     ViInt32*       value)
{
    ViStatus            error = VI_SUCCESS;
    ViString            command;
    ViString            repCommand; 
    IviRangeTablePtr    table;

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xEnum_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xEnum_commands, attributeId, &repCommand));

    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table));

    if (!Ivi_Simulating (vi))
    {
        ViChar  rdBuffer[BUFFER_SIZE];
        ViInt32 rdBufferSize = (ViInt32) sizeof(rdBuffer);

        viCheckErr( viPrintf (io, "%s%s%s?", command, VALID_CHANNELNAME (channelName), repCommand));
        viCheckErr( viScanf(io, "%#s", &rdBufferSize, rdBuffer));
        viCheckErr( ssa3000x_GetValueFromCmd(rdBuffer, table, value));
    }
Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViBoolean_WriteCallback                                               
 * Purpose:  This function sets the bool value of the ViBoolean attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViBoolean_WriteCallback (ViSession        vi,
                                                           ViSession        io,
                                                           ViConstString    channelName,
                                                           ViAttr           attributeId,
                                                           ViBoolean        value)
{
    ViStatus        error = VI_SUCCESS;
    ViString        command;
    ViString        repCommand;

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViBoolean_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViBoolean_commands, attributeId, &repCommand));
    
    if (!Ivi_Simulating (vi))
        viCheckErr( viPrintf (io, "%s%s%s %s", command, VALID_CHANNELNAME (channelName), repCommand, value ? "ON" : "OFF"));

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViBoolean_ReadCallback                                               
 * Purpose:  This function reads the bool value of the ViBoolean attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViBoolean_ReadCallback (ViSession     vi,
                                                          ViSession     io,
                                                          ViConstString channelName,
                                                          ViAttr        attributeId,
                                                          ViBoolean*    value)
{
    ViStatus    error = VI_SUCCESS;
    ViString    command;
    ViString    repCommand; 
    
    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViBoolean_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViBoolean_commands, attributeId, &repCommand));

    if (!Ivi_Simulating (vi))
        viCheckErr( viQueryf (io, "%s%s%s?", "%hd", command, VALID_CHANNELNAME (channelName), repCommand, value));

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViReal64_WriteCallback                                               
 * Purpose:  This function sets the bool value of the ViReal64 attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViReal64_WriteCallback (ViSession     vi,
                                                          ViSession     io,
                                                          ViConstString channelName,
                                                          ViAttr        attributeId,
                                                          ViReal64      value)
{
    ViStatus    error = VI_SUCCESS;
    ViString    command;
    ViString    repCommand;     

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViReal64_commands, attributeId, &command));
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViReal64_commands, attributeId, &repCommand));   
     
    if (!Ivi_Simulating (vi))
    {
		if((int)value==value)
		{
			viCheckErr( viPrintf (io, "%s%s%s %d", command, VALID_CHANNELNAME (channelName), repCommand, (int)value));
		}
        else if(abs(value) < 1.0)
        {
            viCheckErr( viPrintf (io, "%s%s%s %Le", command, VALID_CHANNELNAME (channelName), repCommand, value));
        }
        else
        {
			viCheckErr( viPrintf (io, "%s%s%s %Lf", command, VALID_CHANNELNAME (channelName), repCommand, value));
        }
    }
Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViReal64_ReadCallback                                               
 * Purpose:  This function reads the bool value of the ViReal64 attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViReal64_ReadCallback (ViSession      vi,
                                                         ViSession      io,
                                                         ViConstString  channelName,
                                                         ViAttr         attributeId,
                                                         ViReal64*      value)
{
    ViStatus    error = VI_SUCCESS;
    ViString    command;
    ViString    repCommand; 
    
    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViReal64_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViReal64_commands, attributeId, &repCommand));   

    if (!Ivi_Simulating (vi))
        viCheckErr( viQueryf (io, "%s%s%s?", "%Le", command, VALID_CHANNELNAME (channelName), repCommand, value));

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViInt32_WriteCallback                                               
 * Purpose:  This function sets the bool value of the ViInt32 attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViInt32_WriteCallback (
    ViSession       vi,
    ViSession       io,
    ViConstString   channelName,
    ViAttr          attributeId,
    ViInt32         value
)
{
    ViStatus    error = VI_SUCCESS;
    ViString    command;
    ViString    repCommand;     

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViInt32_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViInt32_commands, attributeId, &repCommand));    

    if (!Ivi_Simulating (vi))
        viCheckErr( viPrintf (io, "%s%s%s %ld", command, VALID_CHANNELNAME (channelName), repCommand, value));

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000xViInt32_ReadCallback                                               
 * Purpose:  This function reads the bool value of the ViInt32 attribute.
 *****************************************************************************/
static ViStatus _VI_FUNC ssa3000xViInt32_ReadCallback (ViSession       vi,
                                                        ViSession       io,
                                                        ViConstString   channelName,
                                                        ViAttr          attributeId,
                                                        ViInt32*        value)
{
    ViStatus    error = VI_SUCCESS;
    ViString    command;
    ViString    repCommand; 
    
    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViInt32_commands, attributeId, &command)); 
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViInt32_commands, attributeId, &repCommand));    

    if (!Ivi_Simulating (vi))
        viCheckErr( viQueryf (io, "%s%s%s?", "%ld", command, VALID_CHANNELNAME (channelName), repCommand, value));

Error:
    return error;
}

/*- SSA3000X_ATTR_ID_QUERY_RESPONSE -*/

static ViStatus _VI_FUNC ssa3000xAttrIdQueryResponse_ReadCallback (ViSession vi, 
                                                                   ViSession io,
                                                                   ViConstString channelName, 
                                                                   ViAttr attributeId,
                                                                   const ViConstString cacheValue)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      rdBuffer[BUFFER_SIZE];
    ViUInt32    retCnt;
    
    viCheckErr( viPrintf (io, "*IDN?"));
    viCheckErr( viRead (io, rdBuffer, BUFFER_SIZE-1, &retCnt));
    rdBuffer[retCnt] = 0;

    checkErr( Ivi_SetValInStringCallback (vi, attributeId, rdBuffer));
    
Error:
    return error;
}
    
/*- SSA3000X_ATTR_SPECIFIC_DRIVER_REVISION -*/

static ViStatus _VI_FUNC ssa3000xAttrDriverRevision_ReadCallback (ViSession vi, 
                                                                  ViSession io,
                                                                  ViConstString channelName, 
                                                                  ViAttr attributeId,
                                                                  const ViConstString cacheValue)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      driverRevision[256];
    
    
    sprintf (driverRevision, 
             "Driver: ssa3000x %d.%d, Compiler: %s %3.2f, "
             "Components: IVIEngine %.2f, VISA-Spec %.2f",
             SSA3000X_MAJOR_VERSION, SSA3000X_MINOR_VERSION, 
             IVI_COMPILER_NAME, IVI_COMPILER_VER_NUM, 
             IVI_ENGINE_MAJOR_VERSION + IVI_ENGINE_MINOR_VERSION/1000.0, 
             Ivi_ConvertVISAVer(VI_SPEC_VERSION));

    checkErr( Ivi_SetValInStringCallback (vi, attributeId, driverRevision));    
Error:
    return error;
}


/*- SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION -*/

static ViStatus _VI_FUNC ssa3000xAttrFirmwareRevision_ReadCallback (ViSession vi, 
                                                                    ViSession io,
                                                                    ViConstString channelName, 
                                                                    ViAttr attributeId,
                                                                    const ViConstString cacheValue)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      idQ[BUFFER_SIZE], rdBuffer[BUFFER_SIZE];
    
    checkErr( Ivi_GetAttributeViString (vi, "", SSA3000X_ATTR_ID_QUERY_RESPONSE,
                                        0, BUFFER_SIZE, idQ));

    sscanf (idQ, "%*[^,],%*[^,],%*[^,],%256[^\n]", rdBuffer);

    checkErr( Ivi_SetValInStringCallback (vi, attributeId, rdBuffer));
    
Error:
    return error;
}

/*- SSA3000X_ATTR_INSTRUMENT_MANUFACTURER -*/

static ViStatus _VI_FUNC ssa3000xAttrInstrumentManufacturer_ReadCallback (ViSession vi, 
                                                                          ViSession io,
                                                                          ViConstString channelName, 
                                                                          ViAttr attributeId,
                                                                          const ViConstString cacheValue)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      rdBuffer[BUFFER_SIZE];
    ViChar      idQ[BUFFER_SIZE];
    
    checkErr( Ivi_GetAttributeViString (vi, "", SSA3000X_ATTR_ID_QUERY_RESPONSE,
                                        0, BUFFER_SIZE, idQ));
    sscanf (idQ, "%256[^,]", rdBuffer);

    checkErr( Ivi_SetValInStringCallback (vi, attributeId, rdBuffer));
    
Error:
    return error;
}

    

/*- SSA3000X_ATTR_INSTRUMENT_MODEL -*/

static ViStatus _VI_FUNC ssa3000xAttrInstrumentModel_ReadCallback (ViSession vi, 
                                                                   ViSession io,
                                                                   ViConstString channelName, 
                                                                   ViAttr attributeId,
                                                                   const ViConstString cacheValue)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      rdBuffer[BUFFER_SIZE];
    ViChar      idQ[BUFFER_SIZE];
    
    checkErr( Ivi_GetAttributeViString (vi, "", SSA3000X_ATTR_ID_QUERY_RESPONSE,
                                        0, BUFFER_SIZE, idQ));
    sscanf (idQ, "%*[^,],%256[^,]", rdBuffer);

    checkErr( Ivi_SetValInStringCallback (vi, attributeId, rdBuffer));
    
Error:
    return error;
}

/* SSA3000X_ATTR_FREQUENCY_SPAN_MODE */        
static ViStatus _VI_FUNC ssa3000xAttrFrequencySpanMode_WriteCallback (ViSession vi,
                                                                       ViSession io, 
                                                                       ViConstString channelName,
                                                                       ViAttr attributeId,
                                                                       ViInt32 value)
{
    ViStatus    error = VI_SUCCESS;
                        
    ViString            commandValue;                       
    IviRangeTablePtr    table;
    
    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table));
    viCheckErr( ssa3000x_GetCmdFromIntValue(value, table, &commandValue));
    
    viCheckErr (viPrintf (io, ":FREQ:SPAN:%s", commandValue));  

Error:
    return error;
}

/* SSA3000X_ATTR_ACTIVE_TRACE */          
static ViStatus _VI_FUNC ssa3000xAttrActiveTrace_CheckCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViConstString value)
{
    return Ivi_CoerceRepCapName(vi, TRACE_REP_CAP_NAME, value, VI_NULL);
}
    
/* SSA3000X_ATTR_TRACE_MATH_TYPE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_HIGH_SENSITIVITY_ENABLE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_VBW_RBW_RATIO_AUTO */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_VBW_RBW_RATIO */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_AVERAGE_DURATION_ENABLE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_AVERAGE_DURATION */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_AVERAGE_TYPE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_AVERAGE_ENABLE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_AVERAGE_COUNT */
/* use common read callback ssa3000xViInt32_ReadCallback */                      
        
/* use common write callback ssa3000xViInt32_WriteCallback */                    
        
/* SSA3000X_ATTR_MEASUREMENT_TYPE */
static ViStatus _VI_FUNC ssa3000xAttrMeasurementType_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViInt32 *value)
{
    ViStatus error = VI_SUCCESS;
    ViInt32  instMode = -1;

    viCheckErr (Ivi_GetAttributeViInt32( vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instMode));

    if (instMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER)
    {
        checkErr( ssa3000xEnum_ReadCallback(vi, io, channelName, attributeId, value));
    }
    else
    {
        *value = SSA3000X_VAL_MEASUREMENT_TYPE_OFF;
    }

Error:
    return error; 
}
        
static ViStatus _VI_FUNC ssa3000xAttrMeasurementType_WriteCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViInt32 value)
{
    ViStatus error = VI_SUCCESS;
    ViInt32  instMode = -1;

    viCheckErr (Ivi_GetAttributeViInt32( vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instMode));

    if (instMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER)
    {
        checkErr( ssa3000xEnum_WriteCallback(vi, io, channelName, attributeId, value));         
    }
    else
    {
        viCheckErrElab(IVI_ERROR_INVALID_CONFIGURATION, 
            "Measurement Type is not available in current instrument mode.");
    }

Error:
    return error; 
}                     
        
/* SSA3000X_ATTR_INSTRUMENT_MODE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_AMPLITUDE_UNITS */
static ViStatus _VI_FUNC ssa3000xAttrAmplitudeUnits_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViInt32 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_ReadCallback(vi, io, VI_NULL, SSA3000X_ATTR_AMPLITUDE_UNITS, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrAmplitudeUnits_WriteCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_WriteCallback(vi, io, VI_NULL, SSA3000X_ATTR_AMPLITUDE_UNITS, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_ATTENUATION */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
                  
static ViStatus _VI_FUNC ssa3000xAttrAttenuation_CoerceCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 value, ViReal64* coercedValue)
{
    ViStatus    error = VI_SUCCESS;
                        
    if(value < 0 || value > 50)
        viCheckErr( IVI_ERROR_INVALID_VALUE);
    
     *coercedValue = (int)(value + 0.5);

Error:
    return error;
}

        
/* SSA3000X_ATTR_ATTENUATION_AUTO */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_DETECTOR_TYPE */
static ViStatus _VI_FUNC ssa3000xAttrDetectorType_ReadCallback (ViSession vi,
                                                                 ViSession io, 
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId, 
                                                                 ViInt32 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  active_trace;
    ViInt32        instrMode = 0;    

    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_ReadCallback(vi, io, active_trace, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrDetectorType_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  active_trace;
    ViInt32        instrMode = 0;    

    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_WriteCallback(vi, io, active_trace, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                     
        
/* SSA3000X_ATTR_FREQUENCY_START */
static ViStatus _VI_FUNC ssa3000xAttrFrequencyStart_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrFrequencyStart_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViReal64 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                     
        
/* SSA3000X_ATTR_FREQUENCY_STOP */
static ViStatus _VI_FUNC ssa3000xAttrFrequencyStop_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrFrequencyStop_WriteCallback (ViSession vi,
                                                                   ViSession io, 
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId,
                                                                   ViReal64 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;   
}
        
/* SSA3000X_ATTR_FREQUENCY_OFFSET */
static ViStatus _VI_FUNC ssa3000xAttrFrequencyOffset_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrFrequencyOffset_WriteCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_INPUT_IMPEDANCE */
static ViStatus _VI_FUNC ssa3000xAttrInputImpedance_ReadCallback (ViSession vi,
                                                                   ViSession io, 
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId, 
                                                                   ViReal64 *value)
{
    ViStatus            error = VI_SUCCESS;
    ViString            command;
    ViString            repCommand;     

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViReal64_commands, attributeId, &command));
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViReal64_commands, attributeId, &repCommand));
    
    if (!Ivi_Simulating (vi))
        viCheckErr( viQueryf (io, "%s%s%s?", "OHM%Lf", command, VALID_CHANNELNAME (channelName), repCommand, value));
    
Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrInputImpedance_WriteCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViReal64 value)
{
    ViStatus            error = VI_SUCCESS;
    ViString            command,
                        commandValue;
    ViString            repCommand;     
    IviRangeTablePtr    table;

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViReal64_commands, attributeId, &command));
    viCheckErr (ssa3000x_GetRepCommandFromTable (ssa3000xViReal64_commands, attributeId, &repCommand));
    
    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table)); 
    viCheckErr( ssa3000x_GetCmdFromRealValue(value, table, &commandValue));
     
    if (!Ivi_Simulating (vi))
    {
        viCheckErr( viPrintf (io, "%s%s%s %s", command, VALID_CHANNELNAME (channelName), repCommand, commandValue));
    }
    
Error:
    return error;
}                  
        
/* SSA3000X_ATTR_CENTER_FREQUENCY */
static ViStatus _VI_FUNC ssa3000xAttrCenterFrequency_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrCenterFrequency_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViReal64 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_FREQUENCY_SPAN */
static ViStatus _VI_FUNC ssa3000xAttrFrequencySpan_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrFrequencySpan_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViReal64 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xViReal64_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_REFERENCE_LEVEL */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */ 

static ViStatus _VI_FUNC ssa3000xAttrReferenceLevel_CheckCallback (ViSession vi,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 value)
{
    ViStatus    error = VI_SUCCESS;
    ViReal64    refLevelMinDbm = -100;
    ViReal64    refLevelMaxDbm = 30;
    ViReal64    newValue = 0;
    
    checkErr( ssa3000x_RecalculateLevelToDBM(vi, value, &newValue));

    if (newValue < refLevelMinDbm || newValue > refLevelMaxDbm )
    {
        viCheckErrElab(IVI_ERROR_INVALID_VALUE, "Invalid value for Reference Level");   
    }
    
Error:
    return error;
}

        
/* SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
                  

/* SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL */ 
static ViStatus _VI_FUNC ssa3000xAttrVideoTriggerLevel_CheckCallback (ViSession vi,
                                                                       ViConstString channelName,
                                                                       ViAttr attributeId,
                                                                       ViReal64 value)
{
    ViStatus    error = VI_SUCCESS;
    ViReal64    trigger_level_dBm  = value;
    ViReal64    reference_level,
                scale_per_division = 10.0;
    
    checkErr( Ivi_GetAttributeViReal64(vi, VI_NULL, SSA3000X_ATTR_REFERENCE_LEVEL, 0, &reference_level));
    checkErr( Ivi_GetAttributeViReal64(vi, VI_NULL, SSA3000X_ATTR_UNITS_PER_DIVISION, 0, &scale_per_division));
    
    checkErr( ssa3000x_RecalculateLevelToDBM( vi, value, &trigger_level_dBm));
    checkErr( ssa3000x_RecalculateLevelToDBM( vi, reference_level, &reference_level));
    
    if ((value < (reference_level - 10.0 * scale_per_division)) || (value > reference_level))
        viCheckErr(IVI_ERROR_INVALID_VALUE);
Error:
    return error;
}

/* SSA3000X_ATTR_RESOLUTION_BANDWIDTH */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_SWEEP_TIME */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
                  
static ViStatus _VI_FUNC ssa3000xAttrSweepTime_CoerceCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 value, ViReal64* coercedValue)
{
    ViStatus    error = VI_SUCCESS;
                        
    if(value < 0)
	{
        viCheckErr( IVI_ERROR_INVALID_VALUE);
	}
    else if(value > 3000)
	{
        *coercedValue = 3000;  
	}
	else
	{
		*coercedValue = value;
	}

Error:
    return error;
}

        
/* SSA3000X_ATTR_SWEEP_MODE */
static ViStatus _VI_FUNC ssa3000xAttrSweepMode_ReadCallback (ViSession vi,
                                                              ViSession io, 
                                                              ViConstString channelName,
                                                              ViAttr attributeId, 
                                                              ViInt32 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ((instrMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) )
    {   
        checkErr( ssa3000xEnum_ReadCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrSweepMode_WriteCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId,
                                                                  ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;    

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ((instrMode == SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER) && (measurementType != SSA3000X_VAL_MEASUREMENT_TYPE_SM) ) 
    {   
        checkErr( ssa3000xEnum_WriteCallback(vi, io, VI_NULL, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_SWEEP_TIME_AUTO */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_TRACE_TYPE */
static ViStatus _VI_FUNC ssa3000xAttrTraceType_ReadCallback (ViSession vi,
                                                              ViSession io, 
                                                              ViConstString channelName,
                                                              ViAttr attributeId, 
                                                              ViInt32 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  active_trace;
    ViInt32        instrMode = 0;    

    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_ReadCallback(vi, io, active_trace, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrTraceType_WriteCallback (ViSession vi,
                                                               ViSession io, 
                                                               ViConstString channelName,
                                                               ViAttr attributeId,
                                                               ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  active_trace;
    ViInt32        instrMode = 0;    

    checkErr( ssa3000x_GetActiveTrace(vi, &active_trace, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if (INSTRUMENT_MODE_IS_SA_TG(instrMode))
    {   
        checkErr( ssa3000xEnum_WriteCallback(vi, io, active_trace, attributeId, value));
    }
    else
    {
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "This function is not applicable in current measurement mode.");
    }

Error:
    return error;
}                     
        
/* SSA3000X_ATTR_VERTICAL_SCALE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_VIDEO_BANDWIDTH */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */ 
static ViStatus _VI_FUNC ssa3000xAttrTgNormalizeReferenceLevel_CoerceCallback (ViSession vi,
                                                                                ViConstString channelName,
                                                                                ViAttr attributeId, 
                                                                                ViInt32 value, 
                                                                                ViInt32* coercedValue)
{
    ViStatus    error = VI_SUCCESS;
                        
    if(value < -200 || value > 200)
        viCheckErr( IVI_ERROR_INVALID_VALUE);
    
    if(value < -200)
    {
        *coercedValue = -200;
    }
    else if(value > 200)
    {
        *coercedValue = 200;
    }
    else
    {
        *coercedValue = value;
    }
     
Error:
    return error;
}
        
/* SSA3000X_ATTR_TG_NORMALIZE_ENABLE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_STEP */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */ 
static ViStatus _VI_FUNC ssa3000xAttrTgOutputAmplitude_CoerceCallback (ViSession vi,
                                                                        ViConstString channelName,
                                                                        ViAttr attributeId, 
                                                                        ViReal64 value, 
                                                                        ViReal64* coercedValue)
{
    ViStatus    error = VI_SUCCESS;
                        
    if(value < -30 || value > 0)
        viCheckErr( IVI_ERROR_INVALID_VALUE);
    
    *coercedValue = -(int)(-value + 0.5);
         
Error:
    return error;
}
        
/* SSA3000X_ATTR_OBW_POWER_LEVEL */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_OBW_POWER_PERCENTAGE */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_OBW_METHOD */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_CHP_BOTTOM_RANGE */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
       
/* SSA3000X_ATTR_CHP_TOP_RANGE */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */ 
        
/* SSA3000X_ATTR_CHP_AUTO_RANGE */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_CHP_CHANNEL_SPAN */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */
static ViStatus _VI_FUNC ssa3000xAttrChpChannelSpan_CheckCallback (ViSession vi,
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 value)
{
    ViStatus    error = VI_SUCCESS;
    ViReal64    min = 1000;
    ViReal64    integrationBandwidth;
    
    checkErr( Ivi_GetAttributeViReal64 (vi, VI_NULL, SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH, 0, &integrationBandwidth));  
    
    if(value < min)
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "The Channel Span should be larger than 1000.");               
    if(value < integrationBandwidth || value > 10*integrationBandwidth)
        viCheckErrElab( IVI_ERROR_INVALID_PARAMETER, 
                        "The Channel Span is between 1 and 10 times the integration bandwidth.");

Error:
    return error;
}
        
/* SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_CHP_CENTER_FREQUENCY */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_ACPR_CENTER_FREQUENCY */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_MARKER_X_READOUT */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_PEAK_SEARCH_TYPE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_MARKER_FUNCTION */        
static ViStatus _VI_FUNC ssa3000xAttrMarkerFunction_ReadCallback (ViSession vi,
                                                                   ViSession io, 
                                                                   ViConstString channelName,
                                                                   ViAttr attributeId, 
                                                                   ViInt32 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;


    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        checkErr( ssa3000xEnum_ReadCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_FUNCTION, value));
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerFunction_WriteCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;


    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        checkErr( ssa3000xEnum_WriteCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_FUNCTION, value));
    }

Error:
    return error;
}

/* SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING */
static ViStatus _VI_FUNC ssa3000xAttrMarkerInstrumentSetting_WriteCallback (ViSession vi,
                                                                             ViSession io, 
                                                                             ViConstString channelName,
                                                                             ViAttr attributeId,
                                                                             ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;
    
    ViString            commandValue;                       
    IviRangeTablePtr    table;    
    
    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table));
    viCheckErr( ssa3000x_GetCmdFromIntValue(value, table, &commandValue));

    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        viCheckErr (viPrintf (io, ":CALC:%s:%s", activeMarker, commandValue));  
    }

Error:
    return error;
}                     
        
/* SSA3000X_ATTR_MARKER_PEAK_SEARCH */
static ViStatus _VI_FUNC ssa3000xAttrMarkerPeakSearch_WriteCallback (ViSession vi,
                                                                      ViSession io, 
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViInt32 value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;   
    
    ViString            commandValue;                       
    IviRangeTablePtr    table;    
    
    checkErr( Ivi_GetAttrRangeTable (vi, channelName, attributeId, &table));
    viCheckErr( ssa3000x_GetCmdFromIntValue(value, table, &commandValue));

    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        if(value == SSA3000X_VAL_MARKER_SEARCH_HIGHEST)
        {
            viCheckErr (viPrintf (io, ":CALC:%s:MAX", activeMarker)); 
        }
        else
        {
            viCheckErr (viPrintf (io, ":CALC:%s:MAX:%s", activeMarker, commandValue));          
        }
    }

Error:
    return error;
}                 
        
/* SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE */
static ViStatus _VI_FUNC ssa3000xAttrMarkerContinuousPeakingEnable_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViBoolean *value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;


    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        checkErr( ssa3000xViBoolean_ReadCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE, value));
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerContinuousPeakingEnable_WriteCallback (ViSession vi,
                                                                                   ViSession io, 
                                                                                   ViConstString channelName,
                                                                                   ViAttr attributeId,
                                                                                   ViBoolean value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;


    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        checkErr( ssa3000xViBoolean_WriteCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE, value));
    }

Error:
    return error;
}
                      
        
/* SSA3000X_ATTR_MARKER_POSITION */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */
/* SSA3000X_ATTR_ACTIVE_MARKER */          
static ViStatus _VI_FUNC ssa3000xAttrActiveMarker_CheckCallback (ViSession vi,
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViConstString value)
{
    return Ivi_CoerceRepCapName(vi, MARKER_REP_CAP_NAME, value, VI_NULL);   
}

        
/* SSA3000X_ATTR_MARKER_AMPLITUDE */
static ViStatus _VI_FUNC ssa3000xAttrMarkerAmplitude_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 *value)
{
    ViStatus       error = VI_SUCCESS;
    ViConstString  activeMarker;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;
    
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                0, &measurementType));

    if ( INSTRUMENT_MODE_IS_SA_TG(instrMode) )
    {
        viCheckErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
        viCheckErr (viQueryf (io, ":CALC:%s:Y?", "%Lg", activeMarker, value));         
    }
    else
    {
        viCheckErrElab(IVI_ERROR_INVALID_CONFIGURATION, 
                       "This function is not applicable in current instrument mode.");
    }   
    
Error:
    return error;
}                     
        
/* SSA3000X_ATTR_MARKER_ENABLED */
/* use common read callback ssa3000xViBoolean_ReadCallback */                    
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED */       
static ViStatus _VI_FUNC ssa3000xAttrMarkerFrequencyCounterEnabled_ReadCallback (ViSession vi,
                                                                                  ViSession io, 
                                                                                  ViConstString channelName,
                                                                                  ViAttr attributeId, 
                                                                                  ViBoolean *value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {   
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_TRUE));
        checkErr( ssa3000xViBoolean_ReadCallback(vi, io, activeMarker, attributeId, value));
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerFrequencyCounterEnabled_WriteCallback (ViSession vi,
                                                                                   ViSession io, 
                                                                                   ViConstString channelName,
                                                                                   ViAttr attributeId,
                                                                                   ViBoolean value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;

    checkErr( Ivi_LockSession (vi, VI_NULL));

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {       
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));	   
		if (!Ivi_Simulating (vi))
		{
			viCheckErr( viPrintf (io, ":CALCulate:%s:FUNCtion  FCOunt",activeMarker));
		}
    }
    
Error:
    return error;
}

/* SSA3000X_ATTR_MARKER_POSITION */        
static ViStatus _VI_FUNC ssa3000xAttrMarkerPosition_ReadCallback (ViSession vi,
                                                                  ViSession io, 
                                                                  ViConstString channelName,
                                                                  ViAttr attributeId, 
                                                                  ViReal64 *value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
    checkErr( ssa3000xViReal64_ReadCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_POSITION, value));

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerPosition_WriteCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId,
                                                                    ViReal64 value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    
    checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
    checkErr( ssa3000xViReal64_WriteCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_POSITION, value));

Error:
    return error; 
}

/* SSA3000X_ATTR_MARKER_THRESHOLD */       
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_ReadCallback (ViSession vi,
                                                                    ViSession io, 
                                                                    ViConstString channelName,
                                                                    ViAttr attributeId, 
                                                                    ViReal64 *value)
{
    ViStatus    error = VI_SUCCESS;

    viCheckErr (viQueryf (io, ":CALC:MARK:PEAK:THR?", "%lf", value));

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerThreshold_WriteCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId,
                                                                     ViReal64 value)
{
    ViStatus    error = VI_SUCCESS;
                        
    viCheckErr (viPrintf (io, ":CALC:MARK:PEAK:THR %lf", value));

Error:
    return error;
}

/* SSA3000X_ATTR_MARKER_TRACE */       
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_ReadCallback (ViSession vi,
                                                                ViSession io,
                                                                ViConstString channelName,
                                                                ViAttr attributeId,
                                                                const ViConstString cacheValue)                                                                  
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    ViChar          specific_trace[BUFFER_SIZE] = "";
    ViInt32         trace_number = 1;
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {       
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE)); 
        if (!Ivi_Simulating (vi)) 
        {
            viCheckErr (viQueryf (io, ":CALC:%s:TRAC?", "%d", activeMarker, &trace_number)); 
        }
        sprintf(specific_trace, "TRACE%ld", trace_number);

        checkErr( Ivi_SetValInStringCallback(vi, attributeId, specific_trace));
    }
    
Error:
    return error;
}

/* SSA3000X_ATTR_MARKER_TRACE */       
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_WriteCallback (ViSession vi,
                                                                 ViSession io, 
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId,
                                                                 ViConstString value) 
                                                                 
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker,
                    specific_trace;
    ViBoolean       is_enabled;    
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;
    ViInt32         traceIndex = 0;


    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {       
        checkErr( Ivi_CoerceRepCapName(vi, TRACE_REP_CAP_NAME, value, &specific_trace));
        checkErr( Ivi_GetRepCapIndex (vi, TRACE_REP_CAP_NAME, specific_trace, &traceIndex)); 

        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE)); 
        checkErr( Ivi_GetAttributeViBoolean(vi, activeMarker, SSA3000X_ATTR_MARKER_ENABLED, 0, &is_enabled));

        if (!Ivi_Simulating (vi)) 
        {
            viCheckErr (viPrintf (io, ":CALC:%s:TRACE %d", activeMarker, traceIndex)); 
        }
        if (!is_enabled)
        {
            checkErr( Ivi_SetAttributeViBoolean (vi, activeMarker,
                                                 SSA3000X_ATTR_MARKER_ENABLED,
                                                 0,
                                                 VI_TRUE));
        }
    }

Error:
    return error;
}

/* SSA3000X_ATTR_MARKER_TRACE */
static ViStatus _VI_FUNC ssa3000xAttrMarkerTrace_CheckCallback (ViSession vi,
                                                                 ViConstString channelName,
                                                                 ViAttr attributeId, 
                                                                 ViConstString value)
{
    return Ivi_CoerceRepCapName(vi, TRACE_REP_CAP_NAME, value, VI_NULL);
}

        
/* SSA3000X_ATTR_PEAK_EXCURSION */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* use common write callback ssa3000xViBoolean_WriteCallback */                      
        
/* SSA3000X_ATTR_TRIGGER_DELAY_TIME */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
        
/* SSA3000X_ATTR_TRIGGER_SOURCE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE */
/* use common read callback ssa3000xEnum_ReadCallback */                     
        
/* use common write callback ssa3000xEnum_WriteCallback */                   
        
/* SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL */
/* use common read callback ssa3000xViReal64_ReadCallback */                     
        
/* use common write callback ssa3000xViReal64_WriteCallback */                   
                  

/* SSA3000X_ATTR_UNITS_PER_DIVISION */     
static ViStatus _VI_FUNC ssa3000xAttrUnitsPerDivision_ReadCallback (ViSession vi,
                                                                     ViSession io, 
                                                                     ViConstString channelName,
                                                                     ViAttr attributeId, 
                                                                     ViReal64 *value)
{
    ViStatus    error = VI_SUCCESS;
    
    if (!Ivi_Simulating (vi)) 
    {
        viCheckErr (viQueryf (io, ":DISP:WIND:TRAC:Y:PDIV?", "DIV%lf", value)); 
    }
                        
Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrUnitsPerDivision_WriteCallback (ViSession vi,
                                                                      ViSession io, 
                                                                      ViConstString channelName,
                                                                      ViAttr attributeId,
                                                                      ViReal64 value)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     int_value = 0;
    
    if (!Ivi_Simulating (vi)) 
    {
        int_value = (ViInt32) value;
        viCheckErr (viPrintf (io, ":DISP:WIND:TRAC:Y:PDIV DIV%d", int_value)); 
    }

Error:
    return error;
}


/* SSA3000X_ATTR_MARKER_TYPE */
static ViStatus _VI_FUNC ssa3000xAttrMarkerType_ReadCallback (ViSession vi,
                                                               ViSession io, 
                                                               ViConstString channelName,
                                                               ViAttr attributeId, 
                                                               ViInt32 *value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {   
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
        viCheckErr(ssa3000xEnum_ReadCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_TYPE, value));
    }

Error:
    return error;
}
        
static ViStatus _VI_FUNC ssa3000xAttrMarkerType_WriteCallback (ViSession vi,
                                                                ViSession io, 
                                                                ViConstString channelName,
                                                                ViAttr attributeId,
                                                                ViInt32 value)
{
    ViStatus        error = VI_SUCCESS;
    ViConstString   activeMarker;
    ViInt32         instrMode = 0;
    ViInt32         measurementType = 0;

    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 
                                         0, &instrMode));
    viCheckErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                         0, &measurementType));

    if ( MEASUREMENT_TYPE_MARKER_CRITERIA(instrMode, measurementType) )
    {   
        checkErr( ssa3000x_GetActiveMarker(vi, &activeMarker, VI_FALSE));
        viCheckErr(ssa3000xEnum_WriteCallback(vi, io, activeMarker, SSA3000X_ATTR_MARKER_TYPE, value));
    }

Error:
    return error;
}
                      

static ViBoolean ssa3000x_OnArrayList(ViAttr attributeId,
                                       ViAttr attrArray[])
{
    ViBoolean onListFlag = VI_FALSE;
    int i = 0;
    
    for(i = 0; ;i++)
    {
        if(attrArray[i] == VI_NULL)
            break;
        
        if(attributeId == attrArray[i])
        {
            onListFlag = VI_TRUE;
            break;
        }
    }
    
    return onListFlag;
}

static ViStatus ssa3000x_ValidConfigCheck(ViSession vi,
                                           ViAttr attributeId)
{
    ViStatus       error = VI_SUCCESS;
    ViInt32        measurementType = 0;
    ViInt32        instrMode = 0;
    ViInt32        demodulationMode = 0;

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));

    switch(instrMode)
    {
    case SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER:
        checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_MEASUREMENT_TYPE, 0, &measurementType));
        switch(measurementType)
        {
        case SSA3000X_VAL_MEASUREMENT_TYPE_ACPR:	  
			checkErr(IVI_ERROR_INVALID_CONFIGURATION);
            break;
        default:
            break;
        }
        break;
    case SSA3000X_VAL_INSTRUMENT_MODE_REFLECTION_MEASUREMENT:		
		checkErr(IVI_ERROR_INVALID_CONFIGURATION);
        break;
    default:
        break;
    }

Error:
    return error;
}


        
        
        

/* SSA3000X_ATTR_ASK_FSK_DEMODULATION_X_SCALE_COUPLING_ENABLE */
/* SSA3000X_ATTR_ASK_FSK_AVERAGE_ENABLE */
/*
static ViStatus _VI_FUNC ssa3000xAttrAskFskNumericViBoolean_ReadCallback (ViSession vi,
                                                                           ViSession io, 
                                                                           ViConstString channelName,
                                                                           ViAttr attributeId, 
                                                                           ViBoolean *value)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     instrMode = 0;
    ViInt32     demodulationMode = 0;
    ViString    command;
    ViInt32     status = -1;

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));
    
    if(instrMode != SSA3000X_VAL_INSTRUMENT_MODE_DEMODULATION)
        checkErr(IVI_ERROR_INVALID_CONFIGURATION); 
    
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_DEMODULATION_MODE, 0, &demodulationMode));

    if(demodulationMode != SSA3000X_VAL_DEMODULATION_MODE_ASK && demodulationMode != SSA3000X_VAL_DEMODULATION_MODE_FSK)
        checkErr(IVI_ERROR_INVALID_CONFIGURATION); 

    viCheckErr( ssa3000x_GetStringFromTable (ssa3000xViBoolean_commands, attributeId, &command));   
    
    if (!Ivi_Simulating (vi)) 
    {
        viCheckErr (viQueryf (io, "%s?", "%d", command, &status)); 
        
        if(status == 1)
            *value = VI_TRUE;
        else
            *value = VI_FALSE;
    }

Error:
    return error;
}
*/
/* SSA3000X_ATTR_AM_FM_DEMODULATION_X_SCALE_COUPLING_ENABLE */      /*
static ViStatus _VI_FUNC ssa3000xAttrAmFmDemodulationXScaleCouplingEnable_ReadCallback (ViSession vi,
                                                                                           ViSession io, 
                                                                                           ViConstString channelName,
                                                                                           ViAttr attributeId, 
                                                                                           ViBoolean *value)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     instrMode = 0;
    ViInt32     demodulationMode = 0;
    ViInt32     status = -1;

    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_INSTRUMENT_MODE, 0, &instrMode));
    
    if(instrMode != SSA3000X_VAL_INSTRUMENT_MODE_DEMODULATION)
    {
        checkErr(IVI_ERROR_INVALID_CONFIGURATION); 
    }
    
    checkErr( Ivi_GetAttributeViInt32 (vi, VI_NULL, SSA3000X_ATTR_DEMODULATION_MODE, 0, &demodulationMode));
    
    if(demodulationMode != SSA3000X_VAL_DEMODULATION_MODE_AM && demodulationMode != SSA3000X_VAL_DEMODULATION_MODE_FM)
    {
        checkErr(IVI_ERROR_INVALID_CONFIGURATION); 
    }
    
    if (!Ivi_Simulating (vi)) 
    {
        viCheckErr (viQueryf (io, ":DISP:AMA:VIEW:WIND:TRAC:X:COUP?", "%d", &status)); 
        
        if(status == 1)
            *value = VI_TRUE;
        else
            *value = VI_FALSE;
    }

Error:
    return error;
}   */

/* SSA3000X_ATTR_DEMODULATION_MODE */


/* SSA3000X_ATTR_REFLECTION_MEASUREMENT_DISTANCE_STOP */

/* SSA3000X_ATTR_REFLECTION_MEASUREMENT_DISTANCE_START */

/* SSA3000X_ATTR_REFLECTION_MEASUREMENT_CABLE_ATTENUATION */


/*****************************************************************************
 * Function: ssa3000x_GetActiveMarker
 * Purpose:  This function returns active marker. 
 *****************************************************************************/
static ViStatus ssa3000x_GetActiveMarker(ViSession       vi,
                                          ViConstString*  pActiveMarker,
                                          ViBoolean       testState)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      buffer[BUFFER_SIZE];
    
    checkErr( Ivi_GetAttributeViString(vi, "", SSA3000X_ATTR_ACTIVE_MARKER, 0, BUFFER_SIZE, buffer));
    checkErr( Ivi_CoerceRepCapName(vi, MARKER_REP_CAP_NAME, buffer, pActiveMarker));
    
    if (testState)
    {
        ViBoolean   marker_state;
        
        checkErr( Ivi_GetAttributeViBoolean(vi, *pActiveMarker, SSA3000X_ATTR_MARKER_ENABLED, 0 , &marker_state));
    
        if (!marker_state)
            viCheckErr(SSA3000X_ERROR_MARKER_NOT_ENABLED);
    }

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_GetActiveTrace
 * Purpose:  This function returns active trace. 
 *****************************************************************************/
static ViStatus ssa3000x_GetActiveTrace(ViSession       vi,
                                         ViConstString*  pActiveTrace,
                                         ViBoolean       testState)
{
    ViStatus    error = VI_SUCCESS;
    ViChar      buffer[BUFFER_SIZE];
    ViInt32     trace_state = 0;
    
    checkErr( Ivi_GetAttributeViString(vi, "", SSA3000X_ATTR_ACTIVE_TRACE, 0, BUFFER_SIZE, buffer));
    checkErr( Ivi_CoerceRepCapName(vi, TRACE_REP_CAP_NAME, buffer, pActiveTrace));
    
    if (testState)
    {
        checkErr( Ivi_GetAttributeViInt32(vi, buffer, SSA3000X_ATTR_TRACE_TYPE, 0 , &trace_state));
    
        if (trace_state == SSA3000X_VAL_TRACE_TYPE_STORE)
            viCheckErr(SSA3000X_ERROR_TRACE_NOT_ENABLED);
    }

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_RecalculateLevelToDBM
 * Purpose:  This function is recalculating value in specified units to dBm
 *           value.
 *****************************************************************************/

static ViStatus ssa3000x_RecalculateLevelToDBM(ViSession   vi,
                                                ViReal64    level,
                                                ViReal64*   levelDBM)
{
    ViStatus    error        = VI_SUCCESS;
    ViReal64    value_in_dBm = level,
                power        = -1.0;
    ViInt32     units;
    
    checkErr( Ivi_GetAttributeViInt32(vi, VI_NULL, SSA3000X_ATTR_AMPLITUDE_UNITS, 0, &units));

    switch (units)
    {
        case SSA3000X_VAL_AMPLITUDE_UNITS_DBMV:
        {
            ViReal64    voltage = pow(10.0, level/20.0)*1.0e-3;
            power = voltage*voltage;
        }
        break;
        case SSA3000X_VAL_AMPLITUDE_UNITS_DBUV:
        {
            ViReal64    voltage = pow(10.0, level/20.0)*1.0e-6;
            power = voltage*voltage;
        }
        break;
        case SSA3000X_VAL_AMPLITUDE_UNITS_VOLT:
            power = level * level;
        break;
        case SSA3000X_VAL_AMPLITUDE_UNITS_WATT:
            if (level > 0.0)
                power = level;
            else
                value_in_dBm = DBL_MAX; /* This is value out of range and will be generate error */
        break;
        case SSA3000X_VAL_AMPLITUDE_UNITS_DBM:
        default:
            value_in_dBm = level;
        break;
    }

    if (power > 0.0)
        value_in_dBm = 10.0*log10(power/1.0e-3);


Error:
    if (levelDBM) 
        *levelDBM = value_in_dBm;
    return error;
}

/*****************************************************************************
 * Function:    ssa3000x_ParseRealArray
 * Purpose:     This function parses string with real values, which are
 *              separated by comma.
 *****************************************************************************/
static ViStatus ssa3000x_ParseRealArray(ViSession vi,
                                         ViChar Buffer[], 
                                         ViInt32 ArrayLength, 
                                         ViInt32 *ActualPoints, 
                                         ViReal64 ResultData[])
{
    ViStatus    error = VI_SUCCESS;
    ViChar*     pToken;
    ViInt32     i;

    if (Buffer == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 1, "Null address for Buffer");

    if (ArrayLength <= 0)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 2, "The length of the array must be greater than 0");

    if (ActualPoints == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 3, "Null address for Actual Points");

    if (ResultData == VI_NULL)
        viCheckParm( IVI_ERROR_INVALID_PARAMETER, 4, "Null address for Result Data");

    pToken = strtok(Buffer, ",");
    
    for (i = 0; i < ArrayLength && pToken != VI_NULL; i++)
    {
        ResultData[i] = atof(pToken);

        pToken = strtok(VI_NULL, ",");
    }

    *ActualPoints = i;

    if (*ActualPoints == ArrayLength && pToken != VI_NULL)
        error = *ActualPoints;

Error:
    return error;
}

/*****************************************************************************
 * Function: ssa3000x_InitAttributes                                                  
 * Purpose:  This function adds attributes to the IVI session, initializes   
 *           instrument attributes, and sets attribute invalidation          
 *           dependencies.                                                   
 *****************************************************************************/
static ViStatus ssa3000x_InitAttributes (ViSession vi,
                                          ViInt32 instModel)
{
    ViStatus    error = VI_SUCCESS;
    ViInt32     flags = 0;
    
        /*- Initialize instrument attributes --------------------------------*/            

    checkErr( Ivi_SetAttrReadCallbackViString (vi, SSA3000X_ATTR_SPECIFIC_DRIVER_REVISION,
                                               ssa3000xAttrDriverRevision_ReadCallback));
    checkErr( Ivi_SetAttributeViInt32 (vi, "", SSA3000X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION,
                                       0, SSA3000X_CLASS_SPEC_MAJOR_VERSION));
    checkErr( Ivi_SetAttributeViInt32 (vi, "", SSA3000X_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION,
                                       0, SSA3000X_CLASS_SPEC_MINOR_VERSION));
    checkErr( Ivi_SetAttributeViString (vi, "", SSA3000X_ATTR_SUPPORTED_INSTRUMENT_MODELS,
                                        0, SSA3000X_SUPPORTED_INSTRUMENT_MODELS));


    checkErr( Ivi_GetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION, &flags));
    checkErr( Ivi_SetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION, 
                                     flags | IVI_VAL_USE_CALLBACKS_FOR_SIMULATION));
    checkErr( Ivi_SetAttrReadCallbackViString (vi, SSA3000X_ATTR_INSTRUMENT_FIRMWARE_REVISION,
                                               ssa3000xAttrFirmwareRevision_ReadCallback));

    checkErr( Ivi_GetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_MANUFACTURER, &flags));
    checkErr( Ivi_SetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_MANUFACTURER, 
                                     flags | IVI_VAL_USE_CALLBACKS_FOR_SIMULATION));
    checkErr( Ivi_SetAttrReadCallbackViString (vi, SSA3000X_ATTR_INSTRUMENT_MANUFACTURER,
                                               ssa3000xAttrInstrumentManufacturer_ReadCallback));


    checkErr( Ivi_GetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_MODEL, &flags));
    checkErr( Ivi_SetAttributeFlags (vi, SSA3000X_ATTR_INSTRUMENT_MODEL, 
                                     flags | IVI_VAL_USE_CALLBACKS_FOR_SIMULATION));
    checkErr( Ivi_SetAttrReadCallbackViString (vi, SSA3000X_ATTR_INSTRUMENT_MODEL,
                                               ssa3000xAttrInstrumentModel_ReadCallback));

    checkErr( Ivi_SetAttributeViString (vi, "", SSA3000X_ATTR_SPECIFIC_DRIVER_VENDOR,
                                        0, SSA3000X_DRIVER_VENDOR));
    checkErr( Ivi_SetAttributeViString (vi, "", SSA3000X_ATTR_SPECIFIC_DRIVER_DESCRIPTION,
                                        0, SSA3000X_DRIVER_DESCRIPTION));
    checkErr( Ivi_SetAttributeViAddr (vi, VI_NULL, IVI_ATTR_CHECK_STATUS_CALLBACK, 0,
                                      ssa3000x_CheckStatusCallback));

        
        
    checkErr( Ivi_SetAttributeViString (vi, "", SSA3000X_ATTR_GROUP_CAPABILITIES, 0,
                                        "IviSpecAnBase,"
                                        "IviSpecAnMultitrace,"
                                        "IviSpecAnMarker,"
                                        "IviSpecAnTrigger,"
                                        "IviSpecAnExternalTrigger,"
                                        "IviSpecAnVideoTrigger,"
                                        "IviSpecAnDisplay,"
                                        "IviSpecAnMarkerType"));
    
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_FREQUENCY_SPAN_MODE,
                                       "SSA3000X_ATTR_FREQUENCY_SPAN_MODE",
                                       SSA3000X_VAL_FREQUENCY_SPAN_MODE_ZERO,
                                       IVI_VAL_NOT_USER_READABLE | IVI_VAL_NEVER_CACHE,
                                       VI_NULL,
                                       ssa3000xAttrFrequencySpanMode_WriteCallback,
                                       &attrFrequencySpanModeRangeTable));
    
    checkErr (Ivi_AddAttributeViString (vi, SSA3000X_ATTR_ACTIVE_TRACE,
                                        "SSA3000X_ATTR_ACTIVE_TRACE", "TRACE1", 0,
                                        VI_NULL, VI_NULL));
    checkErr (Ivi_SetAttrCheckCallbackViString (vi, SSA3000X_ATTR_ACTIVE_TRACE,
                            ssa3000xAttrActiveTrace_CheckCallback)); 
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_TRACE_MATH_TYPE,
                                       "SSA3000X_ATTR_TRACE_MATH_TYPE",
                                       SSA3000X_VAL_TRACE_MATH_TYPE_OFF, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrTraceMathTypeRangeTable));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_VBW_RBW_RATIO_AUTO,
                                         "SSA3000X_ATTR_VBW_RBW_RATIO_AUTO",
                                         VI_TRUE, 0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_VBW_RBW_RATIO,
                                        "SSA3000X_ATTR_VBW_RBW_RATIO", 1.0,
                                        IVI_VAL_NEVER_CACHE,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrVbwRbwRatioRangeTable, 0));
    checkErr (Ivi_AddRepeatedAttributeViBoolean(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_AVERAGE_DURATION_ENABLE,
                        "SSA3000X_ATTR_AVERAGE_DURATION_ENABLE", VI_FALSE,
                        0 ,ssa3000xViBoolean_ReadCallback,
                        ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddRepeatedAttributeViReal64(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_AVERAGE_DURATION,
                        "SSA3000X_ATTR_AVERAGE_DURATION", 60,
                        IVI_VAL_NEVER_CACHE ,ssa3000xViReal64_ReadCallback,
                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_AVERAGE_TYPE,
                                       "SSA3000X_ATTR_AVERAGE_TYPE",
                                       SSA3000X_VAL_AVERAGE_TYPE_LOGPOWER, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrAverageTypeRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViBoolean(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_AVERAGE_ENABLE,
                        "SSA3000X_ATTR_AVERAGE_ENABLE", VI_FALSE,
                        0 ,ssa3000xViBoolean_ReadCallback,
                        ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_AVERAGE_COUNT,
                        "SSA3000X_ATTR_AVERAGE_COUNT", 100,
                        0 ,ssa3000xViInt32_ReadCallback,
                        ssa3000xViInt32_WriteCallback,
                        &attrAverageCountRangeTable));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_MEASUREMENT_TYPE,
                                       "SSA3000X_ATTR_MEASUREMENT_TYPE",
                                       SSA3000X_VAL_MEASUREMENT_TYPE_OFF, 0,
                                       ssa3000xAttrMeasurementType_ReadCallback,
                                       ssa3000xAttrMeasurementType_WriteCallback,
                                       &attrMeasurementTypeRangeTable));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_INSTRUMENT_MODE,
                                       "SSA3000X_ATTR_INSTRUMENT_MODE",
                                       SSA3000X_VAL_INSTRUMENT_MODE_SPECTRUM_ANALYZER,
                                       0, ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrInstrumentModeRangeTable));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_AMPLITUDE_UNITS,
                                       "SSA3000X_ATTR_AMPLITUDE_UNITS",
                                       SSA3000X_VAL_AMPLITUDE_UNITS_DBM, 0,
                                       ssa3000xAttrAmplitudeUnits_ReadCallback,
                                       ssa3000xAttrAmplitudeUnits_WriteCallback,
                                       &attrAmplitudeUnitsRangeTable));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_ATTENUATION,
                                        "SSA3000X_ATTR_ATTENUATION", 20, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_SetAttrCoerceCallbackViReal64 (vi, SSA3000X_ATTR_ATTENUATION,
                            ssa3000xAttrAttenuation_CoerceCallback));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_ATTENUATION_AUTO,
                                         "SSA3000X_ATTR_ATTENUATION_AUTO", VI_TRUE,
                                         0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_DETECTOR_TYPE,
                        "SSA3000X_ATTR_DETECTOR_TYPE", SSA3000X_VAL_DETECTOR_TYPE_MAX_PEAK,
                        0 , ssa3000xAttrDetectorType_ReadCallback,
                        ssa3000xAttrDetectorType_WriteCallback,
                        &attrDetectorTypeRangeTable));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_DETECTOR_TYPE_AUTO,
                                         "SSA3000X_ATTR_DETECTOR_TYPE_AUTO",
                                         VI_NULL, IVI_VAL_NOT_SUPPORTED, VI_NULL,
                                         VI_NULL));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_FREQUENCY_START,
                                        "SSA3000X_ATTR_FREQUENCY_START", 5e6, 0,
                                        ssa3000xAttrFrequencyStart_ReadCallback,
                                        ssa3000xAttrFrequencyStart_WriteCallback,
                                        VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_FREQUENCY_STOP,
                                        "SSA3000X_ATTR_FREQUENCY_STOP", 7e9, 0,
                                        ssa3000xAttrFrequencyStop_ReadCallback,
                                        ssa3000xAttrFrequencyStop_WriteCallback,
                                        VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_FREQUENCY_OFFSET,
                                        "SSA3000X_ATTR_FREQUENCY_OFFSET", 0, 0,
                                        ssa3000xAttrFrequencyOffset_ReadCallback,
                                        ssa3000xAttrFrequencyOffset_WriteCallback,
                                        VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64(vi, SSA3000X_ATTR_INPUT_IMPEDANCE,
                                       "SSA3000X_ATTR_INPUT_IMPEDANCE", SSA3000X_VAL_INPUT_IMPEDANCE_50_OHM,
                                       0 ,ssa3000xAttrInputImpedance_ReadCallback,
                                       ssa3000xAttrInputImpedance_WriteCallback,
                                       &attrInputImpedanceRangeTable, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_CENTER_FREQUENCY,
                                        "SSA3000X_ATTR_CENTER_FREQUENCY", 3.5e9, 0,
                                        ssa3000xAttrCenterFrequency_ReadCallback,
                                        ssa3000xAttrCenterFrequency_WriteCallback,
                                        VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_FREQUENCY_SPAN,
                                        "SSA3000X_ATTR_FREQUENCY_SPAN", 7.0e9, 0,
                                        ssa3000xAttrFrequencySpan_ReadCallback,
                                        ssa3000xAttrFrequencySpan_WriteCallback,
                                        VI_NULL, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_NUMBER_OF_SWEEPS,
                                       "SSA3000X_ATTR_NUMBER_OF_SWEEPS", VI_NULL,
                                       IVI_VAL_NOT_SUPPORTED, VI_NULL, VI_NULL,
                                       VI_NULL));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_REFERENCE_LEVEL,
                                        "SSA3000X_ATTR_REFERENCE_LEVEL", 0,
                                        IVI_VAL_NEVER_CACHE,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_SetAttrCheckCallbackViReal64 (vi, SSA3000X_ATTR_REFERENCE_LEVEL,
                            ssa3000xAttrReferenceLevel_CheckCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET,
                                        "SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET", 0,
                                        IVI_VAL_NEVER_CACHE, ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrReferenceLevelOffsetRangeTable, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_RESOLUTION_BANDWIDTH,
                                        "SSA3000X_ATTR_RESOLUTION_BANDWIDTH", 3e6,
                                        IVI_VAL_NEVER_CACHE,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrResolutionBandwidthRangeTable, 0));
    checkErr (Ivi_AddAttributeViBoolean (vi,
                                         SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO,
                                         "SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO",
                                         VI_TRUE, 0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_SWEEP_MODE_CONTINUOUS,
                                         "SSA3000X_ATTR_SWEEP_MODE_CONTINUOUS",
                                         VI_TRUE, 0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
	checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_SWEEP_TIME,
	                                    "SSA3000X_ATTR_SWEEP_TIME", 0.312, 0,
	                                    ssa3000xViReal64_ReadCallback,
	                                    ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_SetAttrCoerceCallbackViReal64 (vi, SSA3000X_ATTR_SWEEP_TIME,
                            ssa3000xAttrSweepTime_CoerceCallback));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_SWEEP_MODE,
                                       "SSA3000X_ATTR_SWEEP_MODE",
                                       SSA3000X_VAL_SWEEP_MODE_AUTO, 0,
                                       ssa3000xAttrSweepMode_ReadCallback,
                                       ssa3000xAttrSweepMode_WriteCallback,
                                       &attrSweepModeRangeTable));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_SWEEP_TIME_AUTO,
                                         "SSA3000X_ATTR_SWEEP_TIME_AUTO", VI_TRUE,
                                         0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_TRACE_COUNT,
                                       "SSA3000X_ATTR_TRACE_COUNT", 4,
                                       IVI_VAL_NOT_USER_WRITABLE, VI_NULL, VI_NULL,
                                       VI_NULL));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_TRACE_SIZE,
                        "SSA3000X_ATTR_TRACE_SIZE", 751,
                        IVI_VAL_NOT_USER_WRITABLE,
                        VI_NULL, VI_NULL, VI_NULL));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, TRACE_REP_CAP_NAME, SSA3000X_ATTR_TRACE_TYPE,
                        "SSA3000X_ATTR_TRACE_TYPE", SSA3000X_VAL_TRACE_TYPE_CLEAR_WRITE,
                        0 ,ssa3000xAttrTraceType_ReadCallback,
                        ssa3000xAttrTraceType_WriteCallback,
                        &attrTraceTypeRangeTable));

    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_VERTICAL_SCALE,
                                       "SSA3000X_ATTR_VERTICAL_SCALE",
                                       SSA3000X_VAL_VERTICAL_SCALE_LOGARITHMIC, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrVerticalScaleRangeTable));
	checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_VIDEO_BANDWIDTH,
	                                    "SSA3000X_ATTR_VIDEO_BANDWIDTH", 1e6,
	                                    IVI_VAL_NEVER_CACHE,
	                                    ssa3000xViReal64_ReadCallback,
	                                    ssa3000xViReal64_WriteCallback,
	                                    &attrVideoBandwidthRangeTable, 0));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO,
                                         "SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO",
                                         VI_TRUE, 0, ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViInt32 (vi,
                                       SSA3000X_ATTR_TG_NORMAILIZE_REFERENCE_POSITION,
                                       "SSA3000X_ATTR_TG_NORMAILIZE_REFERENCE_POSITION",
                                       10, 0, ssa3000xViInt32_ReadCallback,
                                       ssa3000xViInt32_WriteCallback,
                                       &attrTgNormailizeReferencePositionRangeTable));
    checkErr (Ivi_AddAttributeViInt32 (vi,
                                        SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL,
                                        "SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL",
                                        0, 0, ssa3000xViInt32_ReadCallback,
                                        ssa3000xViInt32_WriteCallback, NULL));
    checkErr (Ivi_SetAttrCoerceCallbackViInt32 (vi, SSA3000X_ATTR_TG_NORMALIZE_REFERENCE_LEVEL,
                            ssa3000xAttrTgNormalizeReferenceLevel_CoerceCallback));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_TG_NORMALIZE_ENABLE,
                                         "SSA3000X_ATTR_TG_NORMALIZE_ENABLE",
                                         VI_FALSE, 0,
                                         ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi,
                                        SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET,
                                        "SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET",
                                        -20, 0, ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViBoolean (vi,
                                         SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE,
                                         "SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE",
                                         VI_FALSE, 0,
                                         ssa3000xViBoolean_ReadCallback,
                                         ssa3000xViBoolean_WriteCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE,
                                        "SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE", -20, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_SetAttrCoerceCallbackViReal64 (vi, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE,
                            ssa3000xAttrTgOutputAmplitude_CoerceCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_OBW_POWER_LEVEL,
                                        "SSA3000X_ATTR_OBW_POWER_LEVEL", 26, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrObwPowerLevelRangeTable, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_OBW_POWER_PERCENTAGE,
                                        "SSA3000X_ATTR_OBW_POWER_PERCENTAGE", 99, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrObwPowerPercentageRangeTable, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_OBW_METHOD,
                                       "SSA3000X_ATTR_OBW_METHOD",
                                       SSA3000X_VAL_OBW_METHOD_PERCENT, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrObwMethodRangeTable));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_CHP_CHANNEL_SPAN,
                                        "SSA3000X_ATTR_CHP_CHANNEL_SPAN", 3e6, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_SetAttrCheckCallbackViReal64 (vi, SSA3000X_ATTR_CHP_CHANNEL_SPAN,
                            ssa3000xAttrChpChannelSpan_CheckCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH,
                                        "SSA3000X_ATTR_CHP_INTEGRATION_BANDWIDTH",
                                        2e6, 0, ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_CHP_CENTER_FREQUENCY,
                                        "SSA3000X_ATTR_CHP_CENTER_FREQUENCY", 3.5e9,
                                        0, ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViReal64 (vi,
                                        SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH,
                                        "SSA3000X_ATTR_ACPR_MAIN_CHANNEL_INTERGRATION_BANDWIDTH",
                                        1e6, IVI_VAL_NEVER_CACHE,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback,
                                        &attrAcprMainChannelIntergrationBandwidthRangeTable,
                                        0));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_ACPR_CENTER_FREQUENCY,
                                        "SSA3000X_ATTR_ACPR_CENTER_FREQUENCY",
                                        3.5E9, 0, ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));
	checkErr (Ivi_AddAttributeViReal64 (vi,
	                                    SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME,
	                                    "SSA3000X_ATTR_MARKER_DEMODULATION_DELAY_TIME",
	                                    5e-3, 0, ssa3000xViReal64_ReadCallback,
	                                    ssa3000xViReal64_WriteCallback, VI_NULL, 0));
	checkErr (Ivi_AddAttributeViReal64 (vi,
	                                    SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME,
	                                    "SSA3000X_ATTR_MARKER_DEMODULATION_SPEAKER_VOLUME",
	                                    6, 0, ssa3000xViReal64_ReadCallback,
	                                    ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi,
                                       SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION,
                                       "SSA3000X_ATTR_MARKER_DEMODULATION_FUNCTION",
                                       SSA3000X_VAL_MARKER_DEMODULATION_FUNCTION_AM,
                                       0, ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrMarkerDemodulationFunctionRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_X_READOUT,
                        "SSA3000X_ATTR_MARKER_X_READOUT", SSA3000X_VAL_MARKER_X_READOUT_FREQUENCY,
                        0 ,ssa3000xEnum_ReadCallback,
                        ssa3000xEnum_WriteCallback,
                        &attrMarkerXReadoutRangeTable));

    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_PEAK_SEARCH_TYPE,
                                       "SSA3000X_ATTR_PEAK_SEARCH_TYPE",
                                       SSA3000X_VAL_PEAK_SEARCH_MODE_MAXIMUM, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrPeakSearchModeRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_FUNCTION,
                        "SSA3000X_ATTR_MARKER_FUNCTION", SSA3000X_VAL_MARKER_FUNCTION_OFF,
                        0 ,ssa3000xAttrMarkerFunction_ReadCallback,
                        ssa3000xAttrMarkerFunction_WriteCallback,
                        &attrMarkerFunctionRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING,
                        "SSA3000X_ATTR_MARKER_INSTRUMENT_SETTING", SSA3000X_VAL_INSTRUMENT_SETTING_FREQUENCY_CENTER,
                        IVI_VAL_NOT_USER_READABLE|IVI_VAL_NEVER_CACHE,
                        VI_NULL, ssa3000xAttrMarkerInstrumentSetting_WriteCallback,
                        &attrMarkerInstrumentSettingRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_PEAK_SEARCH,
                        "SSA3000X_ATTR_MARKER_PEAK_SEARCH", SSA3000X_VAL_MARKER_SEARCH_HIGHEST,
                        IVI_VAL_NOT_USER_READABLE|IVI_VAL_NEVER_CACHE,
                        VI_NULL, ssa3000xAttrMarkerPeakSearch_WriteCallback,
                        &attrMarkerPeakSearchRangeTable));
    checkErr (Ivi_AddRepeatedAttributeViBoolean(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE,
                        "SSA3000X_ATTR_MARKER_CONTINUOUS_PEAKING_ENABLE", VI_FALSE,
                        0 ,ssa3000xAttrMarkerContinuousPeakingEnable_ReadCallback,
                        ssa3000xAttrMarkerContinuousPeakingEnable_WriteCallback));
    checkErr (Ivi_AddAttributeViString (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                        "SSA3000X_ATTR_ACTIVE_MARKER", "MARKER1", 0,
                                        VI_NULL, VI_NULL));
    checkErr (Ivi_SetAttrCheckCallbackViString (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                            ssa3000xAttrActiveMarker_CheckCallback));
    checkErr (Ivi_AddRepeatedAttributeViReal64(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_AMPLITUDE,
                        "SSA3000X_ATTR_MARKER_AMPLITUDE", 0,
                        IVI_VAL_NOT_USER_WRITABLE,
                        ssa3000xAttrMarkerAmplitude_ReadCallback,
                        VI_NULL, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_MARKER_COUNT,
                                       "SSA3000X_ATTR_MARKER_COUNT", 4,
                                       IVI_VAL_NOT_USER_WRITABLE, VI_NULL, VI_NULL,
                                       VI_NULL));

    checkErr (Ivi_AddRepeatedAttributeViBoolean(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_ENABLED,
                        "SSA3000X_ATTR_MARKER_ENABLED", VI_FALSE,
                        0 ,ssa3000xViBoolean_ReadCallback,
                        ssa3000xViBoolean_WriteCallback));

    checkErr (Ivi_AddRepeatedAttributeViBoolean(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED,
                        "SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED", VI_FALSE,
                        0 ,ssa3000xAttrMarkerFrequencyCounterEnabled_ReadCallback,
                        ssa3000xAttrMarkerFrequencyCounterEnabled_WriteCallback));
    checkErr (Ivi_AddAttributeViReal64 (vi,
                                        SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_RESOLUTION,
                                        "SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_RESOLUTION",
                                        0, 0, VI_NULL, VI_NULL, VI_NULL, 0));
	checkErr (Ivi_AddRepeatedAttributeViReal64 (vi, MARKER_REP_CAP_NAME,
	                                            SSA3000X_ATTR_MARKER_POSITION,
	                                            "SSA3000X_ATTR_MARKER_POSITION", 0, 0,
	                                            ssa3000xAttrMarkerPosition_ReadCallback,
	                                            ssa3000xAttrMarkerPosition_WriteCallback,
	                                            VI_NULL, 0));
	checkErr (Ivi_AddRepeatedAttributeViReal64 (vi, MARKER_REP_CAP_NAME,
	                                            SSA3000X_ATTR_MARKER_THRESHOLD,
	                                            "SSA3000X_ATTR_MARKER_THRESHOLD", -160,
	                                            0,
	                                            ssa3000xAttrMarkerThreshold_ReadCallback,
	                                            ssa3000xAttrMarkerThreshold_WriteCallback,
	                                            VI_NULL, 0));
    checkErr (Ivi_AddRepeatedAttributeViString(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_TRACE,
                        "SSA3000X_ATTR_MARKER_TRACE", SSA3000X_VAL_TRACE_NAME_TRACE_1,
                        0 ,ssa3000xAttrMarkerTrace_ReadCallback,
                        ssa3000xAttrMarkerTrace_WriteCallback));

    checkErr (Ivi_SetAttrCheckCallbackViString (vi, SSA3000X_ATTR_MARKER_TRACE,
                            ssa3000xAttrMarkerTrace_CheckCallback));       
	checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_PEAK_EXCURSION,
	                                    "SSA3000X_ATTR_PEAK_EXCURSION", 15, 0,
	                                    ssa3000xViReal64_ReadCallback,
	                                    ssa3000xViReal64_WriteCallback, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViBoolean (vi, SSA3000X_ATTR_SIGNAL_TRACK_ENABLED,
                                         "SSA3000X_ATTR_SIGNAL_TRACK_ENABLED",
                                         VI_NULL, 0, VI_NULL, VI_NULL));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_TRIGGER_SOURCE,
                                       "SSA3000X_ATTR_TRIGGER_SOURCE",
                                       SSA3000X_VAL_TRIGGER_SOURCE_IMMEDIATE, 0,
                                       ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrTriggerSourceRangeTable));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_EXTERNAL_TRIGGER_LEVEL,
                                        "SSA3000X_ATTR_EXTERNAL_TRIGGER_LEVEL", 0,
                                        0, VI_NULL, VI_NULL, VI_NULL, 0));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE,
                                       "SSA3000X_ATTR_EXTERNAL_TRIGGER_SLOPE",
                                       SSA3000X_VAL_EXTERNAL_TRIGGER_SLOPE_POSITIVE,
                                       0, ssa3000xEnum_ReadCallback,
                                       ssa3000xEnum_WriteCallback,
                                       &attrExternalTriggerSlopeRangeTable));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL,
                                        "SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL", 0, 0,
                                        ssa3000xViReal64_ReadCallback,
                                        ssa3000xViReal64_WriteCallback, VI_NULL, 0));

    checkErr (Ivi_SetAttrCheckCallbackViReal64 (vi, SSA3000X_ATTR_VIDEO_TRIGGER_LEVEL,
                            ssa3000xAttrVideoTriggerLevel_CheckCallback)); 
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_VIDEO_TRIGGER_SLOPE,
                                       "SSA3000X_ATTR_VIDEO_TRIGGER_SLOPE", VI_NULL,
                                       0, VI_NULL, VI_NULL,
                                       &attrVideoTriggerSlopeRangeTable));
    checkErr (Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_NUMBER_OF_DIVISIONS,
                                       "SSA3000X_ATTR_NUMBER_OF_DIVISIONS", 10,
                                       IVI_VAL_NOT_USER_WRITABLE, VI_NULL, VI_NULL,
                                       VI_NULL));
    checkErr (Ivi_AddAttributeViReal64 (vi, SSA3000X_ATTR_UNITS_PER_DIVISION,
                                        "SSA3000X_ATTR_UNITS_PER_DIVISION", 10, 0,
                                        ssa3000xAttrUnitsPerDivision_ReadCallback,
                                        ssa3000xAttrUnitsPerDivision_WriteCallback,
                                        &attrUnitsPerDivisionRangeTable, 0));
    checkErr (Ivi_AddRepeatedAttributeViInt32(vi, MARKER_REP_CAP_NAME, SSA3000X_ATTR_MARKER_TYPE,
                        "SSA3000X_ATTR_MARKER_TYPE", SSA3000X_VAL_MARKER_TYPE_OFF,
                        0 ,ssa3000xAttrMarkerType_ReadCallback,
                        ssa3000xAttrMarkerType_WriteCallback,
                        &attrMarkerTypeRangeTable));
    


        
        /*- End of Instrument Specific Attributes -------------------------------*/
    
    checkErr( Ivi_AddAttributeViString (vi, SSA3000X_ATTR_ID_QUERY_RESPONSE,
                                        "SSA3000X_ATTR_ID_QUERY_RESPONSE", 
                                        "",
                                        IVI_VAL_NOT_USER_WRITABLE,
                                        ssa3000xAttrIdQueryResponse_ReadCallback,
                                        VI_NULL));
                                               
    checkErr( Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_OPC_TIMEOUT,
                                       "SSA3000X_ATTR_OPC_TIMEOUT",
                                       5000, IVI_VAL_HIDDEN | IVI_VAL_DONT_CHECK_STATUS,
                                       VI_NULL, VI_NULL, VI_NULL)); 
    checkErr( Ivi_AddAttributeViInt32 (vi, SSA3000X_ATTR_OPC_CALLBACK,
                                       "SSA3000X_ATTR_OPC_CALLBACK",
                                       VI_NULL,
                                       IVI_VAL_HIDDEN | IVI_VAL_DONT_CHECK_STATUS,
                                       VI_NULL, VI_NULL, VI_NULL));
    checkErr( Ivi_AddAttributeViInt32 (vi,
                                       SSA3000X_ATTR_CHECK_STATUS_CALLBACK,
                                       "SSA3000X_ATTR_CHECK_STATUS_CALLBACK",
                                       VI_NULL,
                                       IVI_VAL_HIDDEN | IVI_VAL_DONT_CHECK_STATUS,
                                       VI_NULL, VI_NULL, VI_NULL));
    checkErr( Ivi_AddAttributeViInt32 (vi,
                                       SSA3000X_ATTR_USER_INTERCHANGE_CHECK_CALLBACK,
                                       "SSA3000X_ATTR_USER_INTERCHANGE_CHECK_CALLBACK",
                                       VI_NULL,
                                       IVI_VAL_HIDDEN | IVI_VAL_DONT_CHECK_STATUS,
                                       VI_NULL, VI_NULL, VI_NULL)); 
        
            /*- Setup attribute invalidations -----------------------------------*/
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_INSTRUMENT_MODE,
                                            SSA3000X_ATTR_MEASUREMENT_TYPE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_REFERENCE_LEVEL_OFFSET,
                                            SSA3000X_ATTR_REFERENCE_LEVEL, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ATTENUATION_AUTO,
                                            SSA3000X_ATTR_ATTENUATION, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_DETECTOR_TYPE_AUTO,
                                            SSA3000X_ATTR_DETECTOR_TYPE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_START,
                                            SSA3000X_ATTR_CENTER_FREQUENCY, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_START,
                                            SSA3000X_ATTR_FREQUENCY_SPAN, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_STOP,
                                            SSA3000X_ATTR_CENTER_FREQUENCY, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_STOP,
                                            SSA3000X_ATTR_FREQUENCY_SPAN, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_CENTER_FREQUENCY,
                                            SSA3000X_ATTR_FREQUENCY_START, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_CENTER_FREQUENCY,
                                            SSA3000X_ATTR_FREQUENCY_STOP, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_SPAN,
                                            SSA3000X_ATTR_FREQUENCY_START, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_FREQUENCY_SPAN,
                                            SSA3000X_ATTR_FREQUENCY_STOP, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_RESOLUTION_BANDWIDTH_AUTO,
                                            SSA3000X_ATTR_RESOLUTION_BANDWIDTH, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_SWEEP_TIME_AUTO,
                                            SSA3000X_ATTR_SWEEP_TIME, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VERTICAL_SCALE,
                                            SSA3000X_ATTR_AMPLITUDE_UNITS, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VIDEO_BANDWIDTH_AUTO,
                                            SSA3000X_ATTR_VIDEO_BANDWIDTH, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VBW_RBW_RATIO,
                                            SSA3000X_ATTR_RESOLUTION_BANDWIDTH, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VBW_RBW_RATIO,
                                            SSA3000X_ATTR_VIDEO_BANDWIDTH, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VBW_RBW_RATIO_AUTO,
                                            SSA3000X_ATTR_RESOLUTION_BANDWIDTH, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VBW_RBW_RATIO_AUTO,
                                            SSA3000X_ATTR_VBW_RBW_RATIO, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_VBW_RBW_RATIO_AUTO,
                                            SSA3000X_ATTR_VIDEO_BANDWIDTH, VI_TRUE)); 
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE,
                                            SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_ENABLE,
                                            SSA3000X_ATTR_TG_OUTPUT_AMPLITUDE_OFFSET, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_AMPLITUDE,
                                            SSA3000X_ATTR_ACTIVE_MARKER, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_ACTIVE_MARKER, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_AMPLITUDE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_FUNCTION, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_POSITION, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_TRACE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_MARKER_ENABLED,
                                            SSA3000X_ATTR_MARKER_TYPE, VI_TRUE));
    
    /* SSA3000X_ATTR_ACTIVE_MARKER */
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_MARKER_POSITION, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_MARKER_TRACE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_MARKER_TRACE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_SIGNAL_TRACK_ENABLED, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_MARKER,
                                            SSA3000X_ATTR_MARKER_TYPE, VI_TRUE));
    /* SSA3000X_ATTR_ACTIVE_TRACE */   
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_TRACE, 
                                            SSA3000X_ATTR_DETECTOR_TYPE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_TRACE, 
                                            SSA3000X_ATTR_TRACE_TYPE, VI_TRUE));
    checkErr (Ivi_AddAttributeInvalidation (vi, SSA3000X_ATTR_ACTIVE_TRACE, 
                                            SSA3000X_ATTR_AVERAGE_ENABLE, VI_TRUE));
    
    
Error:
    return error;
}

/*****************************************************************************
 *------------------- End Instrument Driver Source Code ---------------------*
 *****************************************************************************/
